/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import info.aduna.iteration.CloseableIteration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.rdbms.RdbmsTripleRepository;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.SelectProjection;
import org.openrdf.sail.rdbms.algebra.SelectQuery;
import org.openrdf.sail.rdbms.evaluation.QueryBuilder;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.RdbmsTripleSource;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.exceptions.RdbmsQueryEvaluationException;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;
import org.openrdf.sail.rdbms.iteration.RdbmsBindingIteration;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsEvaluation
extends EvaluationStrategyImpl {
    private Logger logger = LoggerFactory.getLogger(RdbmsEvaluation.class);
    private QueryBuilderFactory factory;
    private RdbmsValueFactory vf;
    private RdbmsTripleRepository triples;
    private IdSequence ids;

    public RdbmsEvaluation(QueryBuilderFactory factory, RdbmsTripleRepository triples, Dataset dataset, IdSequence ids) {
        super(new RdbmsTripleSource(triples), dataset);
        this.factory = factory;
        this.triples = triples;
        this.vf = triples.getValueFactory();
        this.ids = ids;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof SelectQuery) {
            return this.evaluate((SelectQuery)expr, bindings);
        }
        return super.evaluate(expr, bindings);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> evaluate(SelectQuery qb, BindingSet b) throws UnsupportedRdbmsOperatorException, RdbmsQueryEvaluationException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        try {
            QueryBindingSet bindings = new QueryBindingSet(b);
            String query = this.toQueryString(qb, bindings, parameters);
            try {
                Connection conn = this.triples.getConnection();
                PreparedStatement stmt = conn.prepareStatement(query);
                int p = 0;
                for (Object e : parameters) {
                    stmt.setObject(++p, e);
                }
                Collection<ColumnVar> proj = qb.getProjections();
                RdbmsBindingIteration rdbmsBindingIteration = new RdbmsBindingIteration(stmt);
                rdbmsBindingIteration.setProjections(proj);
                rdbmsBindingIteration.setBindings(bindings);
                rdbmsBindingIteration.setValueFactory(this.vf);
                rdbmsBindingIteration.setIdSequence(this.ids);
                return rdbmsBindingIteration;
            }
            catch (SQLException e) {
                throw new RdbmsQueryEvaluationException(e.toString() + "\n" + query, e);
            }
        }
        catch (RdbmsException e) {
            throw new RdbmsQueryEvaluationException(e);
        }
    }

    private String toQueryString(SelectQuery qb, QueryBindingSet bindings, List<Object> parameters) throws RdbmsException, UnsupportedRdbmsOperatorException {
        QueryBuilder query = this.factory.createQueryBuilder();
        if (qb.isDistinct()) {
            query.distinct();
        }
        query.from(qb.getFrom());
        for (ColumnVar var : qb.getVars()) {
            for (String name : qb.getBindingNames(var)) {
                if (var.getValue() == null && bindings.hasBinding(name)) {
                    query.filter(var, bindings.getValue(name));
                    continue;
                }
                if (var.getValue() == null || bindings.hasBinding(name) || !qb.getBindingNames().contains(name)) continue;
                bindings.addBinding(name, var.getValue());
            }
        }
        int index = 0;
        for (SelectProjection proj : qb.getSqlSelectVar()) {
            ColumnVar var = proj.getVar();
            if (var.isHiddenOrConstant()) continue;
            for (String name : qb.getBindingNames(var)) {
                if (bindings.hasBinding(name)) continue;
                var.setIndex(index);
                query.select(proj.getId());
                query.select(proj.getStringValue());
                index += 2;
                if (!var.getTypes().isLiterals()) continue;
                query.select(proj.getLanguage());
                query.select(proj.getDatatype());
                index += 2;
            }
        }
        for (SelectQuery.OrderElem by : qb.getOrderElems()) {
            query.orderBy(by.sqlExpr, by.isAscending);
            if (!qb.isDistinct()) continue;
            query.select(by.sqlExpr);
        }
        if (qb.getLimit() != null) {
            query.limit(qb.getLimit());
        }
        if (qb.getOffset() != null) {
            query.offset(qb.getOffset());
        }
        parameters.addAll(query.getParameters());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(query.toString());
            this.logger.debug(parameters.toString());
        }
        return query.toString();
    }
}

