/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.evaluation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class RepositoryTripleSource
implements TripleSource {
    private final RepositoryConnection repo;

    public RepositoryTripleSource(RepositoryConnection repo) {
        this.repo = repo;
    }

    @Override
    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        RepositoryResult<Statement> result;
        try {
            result = this.repo.getStatements(subj, pred, obj, true, contexts);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
        return new ExceptionConvertingIteration<Statement, QueryEvaluationException>(result){

            @Override
            protected QueryEvaluationException convert(Exception exception) {
                return new QueryEvaluationException(exception);
            }
        };
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.repo.getValueFactory();
    }
}

