/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation;

import java.util.List;
import java.util.Random;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.SailException;
import org.openrdf.sail.federation.AbstractEchoWriteConnection;
import org.openrdf.sail.federation.Federation;

class WritableConnection
extends AbstractEchoWriteConnection {
    private int addIndex;

    public WritableConnection(Federation federation, List<RepositoryConnection> members) throws SailException {
        super(federation, members);
        int rnd;
        int size = members.size();
        int n = rnd + size;
        for (int i = rnd = (new Random().nextInt() % size + size) % size; i < n; ++i) {
            try {
                if (!members.get(i % size).getRepository().isWritable()) continue;
                this.addIndex = i % size;
                continue;
            }
            catch (RepositoryException e) {
                throw new SailException(e);
            }
        }
    }

    @Override
    public void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.add((RepositoryConnection)this.members.get(this.addIndex), subj, pred, obj, contexts);
    }

    private void add(RepositoryConnection member, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            member.add(subj, pred, obj, contexts);
        }
        catch (RepositoryException e) {
            throw new SailException(e);
        }
    }

    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatementsInternal(null, null, null, contexts);
    }
}

