/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.federation.PrefixHashSet;
import org.openrdf.sail.federation.ReadOnlyConnection;
import org.openrdf.sail.federation.WritableConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Federation
implements Sail,
Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Federation.class);
    private final List<Repository> members = new ArrayList<Repository>();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private PrefixHashSet localPropertySpace;
    private boolean distinct;
    private boolean readOnly;
    private File dataDir;

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    @Override
    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public ValueFactory getValueFactory() {
        return ValueFactoryImpl.getInstance();
    }

    @Override
    public boolean isWritable() throws SailException {
        return !this.isReadOnly();
    }

    public void addMember(Repository member) {
        this.members.add(member);
    }

    public PrefixHashSet getLocalPropertySpace() {
        return this.localPropertySpace;
    }

    public void setLocalPropertySpace(Collection<String> localPropertySpace) {
        this.localPropertySpace = localPropertySpace.isEmpty() ? null : new PrefixHashSet(localPropertySpace);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public void initialize() throws SailException {
        for (Repository member : this.members) {
            try {
                member.initialize();
            }
            catch (RepositoryException e) {
                throw new SailException(e);
            }
        }
    }

    @Override
    public void shutDown() throws SailException {
        for (Repository member : this.members) {
            try {
                member.shutDown();
            }
            catch (RepositoryException e) {
                throw new SailException(e);
            }
        }
        this.executor.shutdown();
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public SailConnection getConnection() throws SailException {
        ArrayList<RepositoryConnection> connections = new ArrayList<RepositoryConnection>(this.members.size());
        try {
            for (Repository member : this.members) {
                connections.add(member.getConnection());
            }
            return this.readOnly ? new ReadOnlyConnection(this, connections) : new WritableConnection(this, connections);
        }
        catch (RepositoryException e) {
            this.closeAll(connections);
            throw new SailException(e);
        }
        catch (RuntimeException e) {
            this.closeAll(connections);
            throw e;
        }
    }

    private void closeAll(Iterable<RepositoryConnection> connections) {
        for (RepositoryConnection con : connections) {
            try {
                con.close();
            }
            catch (RepositoryException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }
}

