/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfxml.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.rdfxml.RDFXMLWriter;

public class RDFXMLPrettyWriter
extends RDFXMLWriter
implements Closeable,
Flushable {
    private Stack<Node> nodeStack = new Stack();
    private Stack<URI> predicateStack = new Stack();

    public RDFXMLPrettyWriter(OutputStream out) {
        super(out);
    }

    public RDFXMLPrettyWriter(Writer out) {
        super(out);
    }

    @Override
    protected void writeHeader() throws IOException {
        this.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        super.writeHeader();
    }

    @Override
    public void flush() throws IOException {
        if (this.writingStarted) {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            try {
                this.flushPendingStatements();
            }
            catch (RDFHandlerException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.writingStarted) {
                this.endRDF();
            }
        }
        catch (RDFHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.writer.close();
        }
    }

    @Override
    protected void flushPendingStatements() throws IOException, RDFHandlerException {
        if (!this.nodeStack.isEmpty()) {
            this.popStacks(null);
        }
    }

    private void popStacks(Resource newSubject) throws IOException, RDFHandlerException {
        Node nextElement;
        for (int i = 0; i < this.nodeStack.size() - 1; ++i) {
            Node node = (Node)this.nodeStack.get(i);
            if (node.isWritten()) continue;
            if (i > 0) {
                this.writeIndents(i * 2 - 1);
                URI predicate = (URI)this.predicateStack.get(i - 1);
                this.writeStartTag(predicate.getNamespace(), predicate.getLocalName());
                this.writeNewLine();
            }
            this.writeIndents(i * 2);
            this.writeNodeStartTag(node);
            node.setIsWritten(true);
        }
        Node topNode = this.nodeStack.pop();
        if (this.predicateStack.isEmpty()) {
            this.writeIndents(this.nodeStack.size() * 2);
            this.writeNodeEmptyTag(topNode);
            this.writeNewLine();
        } else {
            URI topPredicate = this.predicateStack.pop();
            if (!topNode.hasType()) {
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeAbbreviatedPredicate(topPredicate, topNode.getValue());
            } else {
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeStartTag(topPredicate.getNamespace(), topPredicate.getLocalName());
                this.writeNewLine();
                this.writeIndents(this.nodeStack.size() * 2);
                this.writeNodeEmptyTag(topNode);
                this.writeNewLine();
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeEndTag(topPredicate.getNamespace(), topPredicate.getLocalName());
                this.writeNewLine();
            }
        }
        while (!this.nodeStack.isEmpty() && !(nextElement = this.nodeStack.peek()).getValue().equals(newSubject)) {
            this.nodeStack.pop();
            this.writeIndents(this.predicateStack.size() + this.nodeStack.size());
            this.writeNodeEndTag(nextElement);
            if (this.predicateStack.size() <= 0) continue;
            URI nextPredicate = this.predicateStack.pop();
            this.writeIndents(this.predicateStack.size() + this.nodeStack.size());
            this.writeEndTag(nextPredicate.getNamespace(), nextPredicate.getLocalName());
            this.writeNewLine();
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        Resource subj = st.getSubject();
        URI pred = st.getPredicate();
        Value obj = st.getObject();
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!this.nodeStack.isEmpty() && !subj.equals(this.nodeStack.peek().getValue())) {
                this.popStacks(subj);
            }
            if (this.nodeStack.isEmpty()) {
                this.nodeStack.push(new Node(subj));
            }
            Node topSubject = this.nodeStack.peek();
            if (pred.equals(RDF.TYPE) && obj instanceof URI && !topSubject.hasType() && !topSubject.isWritten()) {
                topSubject.setType((URI)obj);
            } else {
                this.predicateStack.push(pred);
                this.nodeStack.push(new Node(obj));
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    private void writeNodeStartOfStartTag(Node node) throws IOException, RDFHandlerException {
        Value value = node.getValue();
        if (node.hasType()) {
            this.writeStartOfStartTag(node.getType().getNamespace(), node.getType().getLocalName());
        } else {
            this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.toString());
        } else {
            BNode bNode = (BNode)value;
            this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", bNode.getID());
        }
    }

    private void writeNodeStartTag(Node node) throws IOException, RDFHandlerException {
        this.writeNodeStartOfStartTag(node);
        this.writeEndOfStartTag();
        this.writeNewLine();
    }

    private void writeNodeEndTag(Node node) throws IOException {
        if (node.getType() != null) {
            this.writeEndTag(node.getType().getNamespace(), node.getType().getLocalName());
        } else {
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        }
        this.writeNewLine();
    }

    private void writeNodeEmptyTag(Node node) throws IOException, RDFHandlerException {
        this.writeNodeStartOfStartTag(node);
        this.writeEndOfEmptyTag();
    }

    private void writeAbbreviatedPredicate(URI pred, Value obj) throws IOException, RDFHandlerException {
        this.writeStartOfStartTag(pred.getNamespace(), pred.getLocalName());
        if (obj instanceof Resource) {
            Resource objRes = (Resource)obj;
            if (objRes instanceof URI) {
                URI uri = (URI)objRes;
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.toString());
            } else {
                BNode bNode = (BNode)objRes;
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", bNode.getID());
            }
            this.writeEndOfEmptyTag();
        } else if (obj instanceof Literal) {
            Literal objLit = (Literal)obj;
            if (objLit.getLanguage() != null) {
                this.writeAttribute("xml:lang", objLit.getLanguage());
            }
            boolean isXmlLiteral = false;
            URI datatype = objLit.getDatatype();
            if (datatype != null) {
                isXmlLiteral = datatype.equals(RDF.XMLLITERAL);
                if (isXmlLiteral) {
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
                } else {
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", datatype.toString());
                }
            }
            this.writeEndOfStartTag();
            if (isXmlLiteral) {
                this.writer.write(objLit.getLabel());
            } else {
                this.writeCharacterData(objLit.getLabel());
            }
            this.writeEndTag(pred.getNamespace(), pred.getLocalName());
        }
        this.writeNewLine();
    }

    protected void writeStartTag(String namespace, String localName) throws IOException {
        this.writeStartOfStartTag(namespace, localName);
        this.writeEndOfStartTag();
    }

    protected void writeIndents(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeIndent();
        }
    }

    private static class Node {
        private Value value;
        private URI type = null;
        private boolean isWritten = false;

        public Node(Value value) {
            this.value = value;
        }

        public Value getValue() {
            return this.value;
        }

        public void setType(URI type) {
            this.type = type;
        }

        public URI getType() {
            return this.type;
        }

        public boolean hasType() {
            return this.type != null;
        }

        public void setIsWritten(boolean isWritten) {
            this.isWritten = isWritten;
        }

        public boolean isWritten() {
            return this.isWritten;
        }
    }
}

