/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail.config;

import org.openrdf.repository.Repository;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.sail.ProxyRepository;
import org.openrdf.repository.sail.config.ProxyRepositoryConfig;
import org.openrdf.repository.sail.config.RepositoryResolver;
import org.openrdf.repository.sail.config.RepositoryResolverClient;

public class ProxyRepositoryFactory
implements RepositoryFactory,
RepositoryResolverClient {
    public static final String REPOSITORY_TYPE = "openrdf:ProxyRepository";
    private RepositoryResolver resolver;

    @Override
    public void setRepositoryResolver(RepositoryResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    @Override
    public RepositoryImplConfig getConfig() {
        return new ProxyRepositoryConfig();
    }

    @Override
    public Repository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        ProxyRepository result = null;
        if (config instanceof ProxyRepositoryConfig) {
            assert (this.resolver != null) : "Expected resolver to be set.";
        } else {
            throw new RepositoryConfigException("Invalid configuration class: " + config.getClass());
        }
        result = new ProxyRepository(this.resolver, ((ProxyRepositoryConfig)config).getProxiedRepositoryID());
        return result;
    }
}

