/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.text.tsv;

import info.aduna.text.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultWriterBase;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

public class SPARQLResultsTSVWriter
extends QueryResultWriterBase
implements TupleQueryResultWriter {
    private Writer writer;
    private List<String> bindingNames;
    protected boolean tupleVariablesFound = false;

    public SPARQLResultsTSVWriter(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        this.writer = new BufferedWriter(w, 1024);
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.tupleVariablesFound = true;
        this.bindingNames = bindingNames;
        try {
            for (int i = 0; i < bindingNames.size(); ++i) {
                this.writer.write("?");
                this.writer.write(bindingNames.get(i));
                if (i >= bindingNames.size() - 1) continue;
                this.writer.write("\t");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Must call startQueryResult before handleSolution");
        }
        try {
            for (int i = 0; i < this.bindingNames.size(); ++i) {
                String name = this.bindingNames.get(i);
                Value value = bindingSet.getValue(name);
                if (value != null) {
                    this.writeValue(value);
                }
                if (i >= this.bindingNames.size() - 1) continue;
                this.writer.write("\t");
            }
            this.writer.write("\r\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.TSV;
    }

    @Override
    public final TupleQueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    protected void writeValue(Value val) throws IOException {
        if (val instanceof Resource) {
            this.writeResource((Resource)val);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof URI) {
            this.writeURI((URI)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeURI(URI uri) throws IOException {
        String uriString = uri.toString();
        this.writer.write("<" + uriString + ">");
    }

    protected void writeBNode(BNode bNode) throws IOException {
        this.writer.write("_:");
        this.writer.write(bNode.getID());
    }

    private void writeLiteral(Literal lit) throws IOException {
        String label = lit.getLabel();
        boolean quoted = false;
        if (lit.getDatatype() != null || lit.getLanguage() != null) {
            quoted = true;
            this.writer.write("\"");
        }
        this.writer.write(SPARQLResultsTSVWriter.encodeString(label));
        if (quoted) {
            this.writer.write("\"");
        }
        if (lit.getLanguage() != null) {
            this.writer.write("@");
            this.writer.write(lit.getLanguage());
        } else if (lit.getDatatype() != null) {
            this.writer.write("^^");
            this.writeURI(lit.getDatatype());
        }
    }

    private static String encodeString(String s) {
        s = StringUtil.gsub("\\", "\\\\", s);
        s = StringUtil.gsub("\t", "\\t", s);
        s = StringUtil.gsub("\n", "\\n", s);
        s = StringUtil.gsub("\r", "\\r", s);
        s = StringUtil.gsub("\"", "\\\"", s);
        return s;
    }

    @Override
    public void startDocument() throws TupleQueryResultHandlerException {
    }

    @Override
    public void handleStylesheet(String stylesheetUrl) throws TupleQueryResultHandlerException {
    }

    @Override
    public void startHeader() throws TupleQueryResultHandlerException {
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws TupleQueryResultHandlerException {
    }

    @Override
    public void endHeader() throws TupleQueryResultHandlerException {
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }
}

