/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;

public class OrderIterator
extends DelayedIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private final Comparator<BindingSet> comparator;
    private final long limit;
    private final boolean distinct;

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator) {
        this(iter, comparator, Integer.MAX_VALUE, false);
    }

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, long limit, boolean distinct) {
        this.iter = iter;
        this.comparator = comparator;
        this.limit = limit;
        this.distinct = distinct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        NavigableMap<BindingSet, Collection<BindingSet>> map = this.makeOrderedMap(this.comparator);
        int size = 0;
        try {
            while (this.iter.hasNext()) {
                BindingSet next = (BindingSet)this.iter.next();
                if ((long)size >= this.limit && this.comparator.compare(next, (BindingSet)map.lastKey()) >= 0) continue;
                Collection<BindingSet> list = (Collection<BindingSet>)map.get(next);
                if (list == null) {
                    list = this.distinct ? this.makeOrderedSet() : this.makeList();
                    this.put(map, next, list);
                }
                if (this.add(next, list)) {
                    ++size;
                }
                if ((long)size <= this.limit) continue;
                BindingSet lastKey = (BindingSet)map.lastKey();
                Collection lastResults = (Collection)map.get(lastKey);
                assert (!lastResults.isEmpty());
                this.removeLast(lastResults);
                --size;
                if (!lastResults.isEmpty()) continue;
                this.remove(map, lastKey);
            }
        }
        finally {
            this.iter.close();
        }
        final Iterator values = map.values().iterator();
        return new LookAheadIteration<BindingSet, QueryEvaluationException>(){
            private volatile Iterator<BindingSet> iterator = Collections.emptyList().iterator();

            @Override
            protected BindingSet getNextElement() {
                while (!this.iterator.hasNext() && values.hasNext()) {
                    this.iterator = ((Collection)values.next()).iterator();
                }
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return null;
            }
        };
    }

    protected List<BindingSet> makeList() {
        return new LinkedList<BindingSet>();
    }

    protected Set<BindingSet> makeOrderedSet() {
        return new LinkedHashSet<BindingSet>();
    }

    protected void removeLast(Collection<BindingSet> lastResults) {
        if (lastResults instanceof LinkedList) {
            ((LinkedList)lastResults).removeLast();
        } else if (lastResults instanceof List) {
            ((List)lastResults).remove(lastResults.size() - 1);
        } else {
            Iterator<BindingSet> iter = lastResults.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            iter.remove();
        }
    }

    protected Collection<BindingSet> remove(NavigableMap<BindingSet, Collection<BindingSet>> map, BindingSet lastKey) {
        return (Collection)map.remove(lastKey);
    }

    protected boolean add(BindingSet next, Collection<BindingSet> list) throws QueryEvaluationException {
        return list.add(next);
    }

    protected Collection<BindingSet> put(Map<BindingSet, Collection<BindingSet>> map, BindingSet next, Collection<BindingSet> list) throws QueryEvaluationException {
        return map.put(next, list);
    }

    protected NavigableMap<BindingSet, Collection<BindingSet>> makeOrderedMap(Comparator<BindingSet> comparator2) {
        return new TreeMap<BindingSet, Collection<BindingSet>>(this.comparator);
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        this.iter.close();
        super.handleClose();
    }
}

