% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_target.R
\name{merge_bam_files}
\alias{merge_bam_files}
\title{Merge multiple .bam files}
\usage{
merge_bam_files(
  bam_files,
  destination,
  head_file = paste(destination, "_header.sam", sep = ""),
  quiet = TRUE
)
}
\arguments{
\item{bam_files}{A list of file names for the .bam files to be merged.}

\item{destination}{A file name and location for the merged .bam file.}

\item{head_file}{A file name and location for the combined header file.
Defaults to the destination. For example, 'example.bam' will be written as
'example.bam'.}

\item{quiet}{Turns off most messages. Default is \code{TRUE}.}
}
\value{
This function merges .bam files and combines them into a single file.
The function also outputs the new .bam filename.
}
\description{
This function merges .bam files. It first used the combined_header function
to generate a combined header for all the files, reheaders the files, and
then merges and sorts the .bam files. It is similar to the 'samtools merge'
function, but it allows the .bam files to have different headers. It is not
intended for direct use.
}
