% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibd.R
\name{MouseColonIbdCadinu2024}
\alias{MouseColonIbdCadinu2024}
\title{MERFISH mouse colon IBD dataset from Cadinu et al., 2024}
\source{
\url{https://doi.org/10.5061/dryad.rjdfn2zh3}
}
\usage{
MouseColonIbdCadinu2024()
}
\value{
An object of class \code{\linkS4class{SpatialExperiment}}.
}
\description{
Obtain the MERFISH mouse colon IBD dataset from Cadinu et al.,
2024
}
\details{
Gut inflammation involves contributions from immune and non-immune cells,
whose interactions are shaped by the spatial organization of the healthy gut and its
remodeling during inflammation.
The crosstalk between fibroblasts and immune cells is an important axis in this process,
but our understanding has been challenged by incomplete cell-type definition and biogeography.

To address this challenge, Cadinu et al., 2024 used multiplexed error-robust
fluorescence in situ hybridization
(MERFISH) to profile the expression of 943 genes in 1.35 million cells imaged
across the onset and recovery from a mouse colitis model.
They identified diverse cell populations, charted their
spatial organization, and revealed their polarization or recruitment in
inflammation.

The barcoding scheme contained 990 possible barcodes; 943 of them were used to
code the RNAs of the genes assayed via combinatorial smFISH across different
stages of colitis in a mouse model; 47 of these barcodes
were left unassigned ("blank"), providing a direct measure of the false-positive
rate in MERFISH. Measurements for these 47 blank barcodes is stored in an
\code{altExp} named \code{"blank"}.

The dataset includes cell type labels with three levels of granularity.
Data were collected at multiple time points: prior to the onset of colitis
(\code{sample_type="Healthy"}) and at intervals of 3 days, 9 days,
and 21 days post-onset.
}
\examples{
spe <- MouseColonIbdCadinu2024()
}
\references{
Cadinu et al. (2024) Charting the cellular biogeography in
colitis reveals fibroblast trajectories and coordinated spatial remodeling.
Cell, 187(8).
}
