\name{MMDiffBamSubset-package}
\alias{MMDiffBamSubset-package}
\alias{MMDiffBamSubset}
\alias{Cfp1.Exp}
\alias{WT.AB2}
\alias{Null.AB2}
\alias{Resc.AB2}
\alias{Input}
\alias{WT.AB2.Peaks}
\alias{Null.AB2.Peaks}
\alias{Resc.AB2.Peaks}

\title{Utilities returning the paths to the sample sheet Cfp1.csv, to
  the BAM files WT_2.bam, Null_2.bam, Resc_2.bam and Input.bam, as well
  as corresponding peak files WT_2_Macs_peaks.xls, Null_2_Macs_peaks.xls
  Resc_2_Macs_peaks.xls}

\description{Cfp1.csv Sample Sheet containing meta information about the
experiment.

  BAM files each containing subsets of original files with
  reads mapping to region ch1:3000000...75000000.  The data is available
  as part of ArrayExpress Experiment E-ERAD-79, which contains ChIP-Seq
  of mice cells to assess the link between histone modification states
  of H3K4me3 with respect to the mediator proteins Cfp1.

  WT_2.bam: organism: Mus musculus; Cell type: ES cells,
  Immunoprecipitate: H3K4me3

  Null_2.bam: organism: Mus musculus; Cell type: Cfp1 -/- ES cells,
  Immunoprecipitate: H3K4me3

  Resc_2.bam: organism: Mus musculus; Cell type: Cfp1-/- ES cells and
  wtCfp1 rescue cDNA, Immunoprecipitate: H3K4me3

  Input.bam: organism: Mus musculus; input_DNA (pooled from different
  cell types)

  \code{WT.AB2}, \code{Null.AB2}, \code{Resc.AB2} and \code{Input} return the path to
  those files.

  Additionally, subsets of peaks called by MACS[2] are provided.

  \code{WT.AB2.Peaks}, \code{Null.AB2.Peaks} and \code{Resc.AB2.Peaks}
  return the path to the respective peak files.}

\usage{
Cfp1.Exp()
WT.AB2()
Null.AB2()
Resc.AB2()
Input()
WT.AB2.Peaks()
Null.AB2.Peaks()
Resc.AB2.Peaks()
}

\details{ See the MMDiff package or [1] for details about the experiment
  (ChIP-seq, H3K4me3, Mus musculus).  BAM files contain single-end reads
  aligned to reference genome \emph{NBCI37/mm9} }

\references{
  [1] Clouaire T et al. (2012). Cfp1 integrates both CpG content and gene activity for accurate H3K4me3 deposition in embryonic stem cells.
  Genes Dev. August 1, 2012 26: 1714--1728

  [2] Zhang Y et al. (20078). Model-based analysis of ChIP-Seq (MACS). Genome Biol 2008, 9(9):R137.
}

\examples{
Cfp1.Exp()
WT.AB2()
Null.AB2()
Resc.AB2()
Input()
WT.AB2.Peaks()
Null.AB2.Peaks()
Resc.AB2.Peaks()
}
\keyword{utilities}