\name{IMR90.WGBS}
\alias{IMR90.WGBS}
\docType{data}
\title{
  BS-seq data of IMR90 cell line
}
\description{
  BS-seq data of IMR90 cell line from Lister et al. 2009
}
\details{
  This is the BS-seq dataset of IMR90 cell line (Lister et al. 2009).
  The dataset has been stored in BSdata class of package methylPipe and
  can directly be used for further analysis using the package.
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg18)
imr90data <- system.file('extdata', 'mc_i90_tabix.txt.gz', package='ListerEtAlBSseq')
imr90uncov <- system.file('extdata', 'uncov_GR_imr90.Rdata', package='ListerEtAlBSseq')
load(imr90uncov)
IMR90.WGBS <- BSdata(file=imr90data, uncov=uncov_GR_imr90, org=Hsapiens)
}
\keyword{datasets}
