% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot a ComplexHeatmap.}
\usage{
plot_heatmap(
  inputData,
  annotationData = NULL,
  plot_title = NULL,
  name = "Input data",
  plottingColNames,
  annotationColNames = NULL,
  colList = list(),
  scale = FALSE,
  showColumnNames = TRUE,
  showRowNames = TRUE,
  colorSets = c("Set1", "Set2", "Set3", "Pastel1", "Pastel2", "Accent", "Dark2",
    "Paired"),
  choose_color = c("blue", "gray95", "red"),
  split_heatmap = "none",
  annotationplotting = NULL,
  column_order = NULL,
  ...
)
}
\arguments{
\item{inputData}{an input data object. It should either be of the class
\code{SummarizedExperiment} and contain the data and
annotation data as columns in the colData, or alternatively be of the classes
\code{data.frame} or \code{matrix} and contain only the plotting data.
Required.}

\item{annotationData}{a \code{data.frame} or \code{matrix} of annotation
data, with one column. Only required if \code{inputData} is a
\code{data.frame} or \code{matrix} of plotting data.
The row names must equal those of the \code{inputData} column names.
Default is \code{NULL}.}

\item{plot_title}{a character string with the plot title of the heatmap. The
default is \code{NULL}.}

\item{name}{a character string with the name of the data to be displayed.
Default is \code{"Input data"}.}

\item{plottingColNames}{a vector of the column names in \code{colData} that
contain the plotting data. Only required if \code{inputData} is a
SummarizedExperiment object.}

\item{annotationColNames}{a vector of the column names in \code{colData} that
contain the annotation data. Only required if \code{inputData} is a
\code{SummarizedExperiment}. Default is \code{NULL}.}

\item{colList}{a named \code{list} of named vectors specifying custom color
information to
pass to \code{ComplexHeatmap::Heatmap()}. The list should have as many
elements as there are annotation columns, and each element name should
correspond exactly with the name of each annotation column.
The colors in the vector elements should be named according to the
levels of the factor in that column's annotation data if the annotation
is discrete, or it should be produced with \code{circlize::colorRamp2}
if the annotation is continuous.
By default, \code{ColorBrewer} color sets will be used.
See the the parameter \code{colorSets} for additional details.}

\item{scale}{logical. Setting \code{scale = TRUE} scales the plotting data.
The default is \code{FALSE}.}

\item{showColumnNames}{logical. Setting \code{showColumnNames = TRUE} will
show the column names (i.e. sample names) on the heatmap. The default is
\code{TRUE}.}

\item{showRowNames}{logical. Setting \code{showColumnNames = TRUE} will
show the row names (i.e. plotting names) on the heatmap. The default is
\code{TRUE}.}

\item{colorSets}{a vector of names listing the color sets in the order
that they should be used in creating the heatmap. By default, this function
will use the color sets in the order listed in \code{Usage} for annotation
information. You may replace the default with the same collection of sets
in order that you want to use them, or provide custom color sets with the
\code{colList} parameter.}

\item{choose_color}{a vector of color names to be interpolated for the
heatmap gradient, or a \code{colorRamp} function produced by
\code{circlize::colorRamp2}. The default is \code{c("blue", "gray95", "red")}.}

\item{split_heatmap}{a character string either giving the column title of
\code{annotationplotting} containing annotation data for which to split
the heatmap rows, or \code{"none"} if no split is desired.}

\item{annotationplotting}{a \code{data.frame} or \code{matrix} with information
to be used
in splitting the heatmap. The first column should plotting names. The
column of annotation information should be specified in \code{split_heatmap.}
Other columns will be ignored. The default is \code{sigAnnotData}.}

\item{column_order}{a vector of character strings indicating the order in
which to manually arrange the heatmap columns. Default is \code{NULL},
such that column order is automatically determined via clustering.}

\item{...}{Additional arguments to be passed to
\code{ComplexHeatmap::Heatmap()}.}
}
\value{
A ComplexHeatmap plot.
}
\description{
This function takes an arbitrary dataset as an input and returns a
\code{ComplexHeatmap} plot of samples based on similarity of microbial
abundances. The function takes arguments listed here as well
as any others to be passed on to \code{ComplexHeatmap::Heatmap()}. Note, the
"circlize" and "ComplexHeatmap" packages are required to use this function.
}
\details{
If both \code{annotationData = NULL} and \code{annotationColNames = NULL},
no annotation bar will be drawn on the heatmap.

Code was adapted from the \code{TBSignatureprofiler} R package.
}
\examples{
library(SummarizedExperiment)
# Example with a Summarized Experiment data object
dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
input_SE <- dat[["MicrobeGenetics"]]

## Creating a continuous color ramp annot col list
Hairrange <- range(colData(input_SE)[, "HairLength"])
color2 <- circlize::colorRamp2(c(Hairrange[1], Hairrange[2]), c("blue", "red"))
color.list <- list("HairLength" = color2)

## Create plot
plot_heatmap(
  inputData = input_SE,
  name = "Microbe abundances",
  plot_title = "Example Heatmap",
  plottingColNames = colnames(input_SE),
  annotationColNames = "HairLength",
  colList = color.list,
  scale = TRUE,
  showColumnNames = TRUE,
  showRowNames = FALSE,
  colorSets = 
    c("Set1", "Set2", "Set3", "Pastel1", "Pastel2", "Accent", "Dark2",
      "Paired"),
  choose_color = c("blue", "gray95", "red"),
  split_heatmap = "none",
  column_order = NULL
)

# Artificial data example - matrix input
mat_testdata <- rbind(matrix(c(rnorm(80), rnorm(80) + 5), 16, 10,
                             dimnames = list(paste0("Taxon", seq_len(16)),
                                             paste0("sample", seq_len(10)))),
                      matrix(rnorm(1000), 100, 10,
                             dimnames = list(paste0("Taxon0", seq_len(100)),
                                             paste0("sample", seq_len(10)))))
cov_mat <- data.frame(sample = c(rep("down", 5), rep("up", 5))) |>
  magrittr::set_rownames(paste0("sample", seq_len(10)))

# Example using custom colors for the annotation information
color2 <- stats::setNames(c("purple", "black"), c("down", "up"))
color.list <- list("sample" = color2)

plot_heatmap(
  inputData = mat_testdata,
  annotationData = cov_mat,
  name = "Data",
  plot_title = "Example",
  plottingColNames = NULL,
  annotationColNames = NULL,
  colList = color.list,
  scale = FALSE,
  showColumnNames = TRUE,
  showRowNames = FALSE,
  colorSets = c("Set1", "Set2", "Set3", "Pastel1", "Pastel2", "Accent", "Dark2",
                "Paired"),
  choose_color = c("blue", "gray95", "red"),
  split_heatmap = "none",
  column_order = NULL
)

}
\author{
David Jenkins, Aubrey Odom
}
