% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMIT.R
\name{tscor}
\alias{tscor}
\title{Calculate within-subject OTU correlations}
\usage{
tscor(dat, unit_var, method = "kendall", fill_na = 0)
}
\arguments{
\item{dat}{A \code{MultiAssayExperiment} object specially formatted as an
animalcules output.}

\item{unit_var}{a numeric vector of subject.}

\item{method}{an option of the correlation method ("pearson", "kendall",
"spearman"). The default method is "kendall".}

\item{fill_na}{a number between 0 and 1 to fill the missing value. The
default value is 0.}
}
\value{
An three-dimensional array of temporal correlation matrices for each
  subject.
}
\description{
This function takes a \code{MultiAssayExperiment} and outputs an array of
temporal intra-subject correlation matrices.
}
\examples{
dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
output <- tscor(dat, unit_var = "Subject", method = "spearman")
head(output)

}
\author{
Yilong Zhang, Huilin Li, Aubrey Odom
}
