% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_lmm_model.R
\name{run_lmm_model}
\alias{run_lmm_model}
\title{Compute linear mixed-effects models (LMM) on longitudinal microbiome data}
\usage{
run_lmm_model(
  dat,
  taxon_level = "genus",
  unit_var,
  fixed_cov,
  p_adj_method = "fdr",
  plot_out = FALSE,
  plotsave_loc = ".",
  plot_terms = NULL,
  ...
)
}
\arguments{
\item{dat}{A MultiAssayExperiment object specially formatted as an animalcules output.}

\item{taxon_level}{Character string, default is \code{"genus"}.}

\item{unit_var}{A character string identifying the unit variable for which
there are multiple observations. Required.}

\item{fixed_cov}{A character vector naming covariates to be tested.}

\item{p_adj_method}{A character string specifying the correction method. Can
be abbreviated. See details. Default is \code{"fdr"}.}

\item{plot_out}{Logical indicating whether plots should be output alongside
the model results. Default is \code{FALSE}.}

\item{plotsave_loc}{A character string giving the folder path to save plot
outputs. This defaults to the current working directory.}

\item{plot_terms}{Character vector. Which terms should be examined in the
plot output? Can overlap with the \code{fixed_cov} inputs.}

\item{...}{Further arguments passed to \code{ggsave} for plot creation.}
}
\value{
A \code{data.frame} of modeling results.
}
\description{
This function takes an animalcules-formatted \code{MultiAssayExperiment} and
runs an independent LMM model for each taxon. The model predicts taxon log
CPM abundance as a product of fixed-effects covariates with a random effect,
usually the unit on which repeated measurements were taken. Note, the 'broom',
'lmerTest', and 'broom.mixed' packages are required to use this function; they can
be downloaded from CRAN.
}
\details{
P-values are adjusted for the model coefficients within each taxon. The
following methods are permitted: \code{c("holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr", "none")}
}
\examples{
dat <- system.file("extdata/MAE.RDS", package = "LegATo") |>
  readRDS() |>
  filter_MAE()
out <- run_lmm_model(dat, taxon_level = "genus", unit_var = "Subject",
                     fixed_cov = c("HIVStatus", "timepoint"))
head(out)

}
