% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMIT.R
\name{NMIT}
\alias{NMIT}
\title{Nonparametric Microbial Interdependence Test (NMIT)}
\usage{
NMIT(
  dat,
  unit_var,
  fixed_cov,
  covariate_time,
  method = "kendall",
  dist_type = "F",
  heatmap = TRUE,
  classify = FALSE,
  fill_na = 0,
  ...
)
}
\arguments{
\item{dat}{A \code{MultiAssayExperiment} object specially formatted as an
animalcules output.}

\item{unit_var}{a numeric vector of subject.}

\item{fixed_cov}{A character vector of the names of covariates of interest found in
\code{dat}.}

\item{covariate_time}{Character string giving the name of the discrete
time-based covariate in the metadata to group abundances by.}

\item{method}{an option of the correlation method ("pearson", "kendall",
"spearman"). The default method is "kendall".}

\item{dist_type}{A character string specifying the type of matrix norm to be
computed. The default is \code{"F"}.
* \code{"M"} or \code{"m"} specifies the maximum modulus of all the
  elements in \code{x};
* \code{"O"}, \code{"o"} or \code{"1"} specifies the one norm,
  (maximum absolute column sum);
* \code{"I"} or \code{"i"} specifies the infinity norm (maximum
  absolute row sum);
* \code{"F"} or \code{"f"} specifies the Frobenius norm (the
  Euclidean norm of \code{x} treated as if it were a vector)}

\item{heatmap}{A logical value indicating whether to draw heatmap. The
default is \code{TRUE}.}

\item{classify}{A logical value indicating whether to draw a classifier tree.
The default is \code{FALSE}.}

\item{fill_na}{A number between 0 and 1 to fill \code{NA} values. The default
value is 0.}

\item{...}{Additional arguments to be passed to \code{ComplexHeatmap::Heatmap()}.}
}
\value{
This function returns an analysis of variance (ANOVA) table showing
  sources of variation, degrees of freedom, sequential sums of squares, mean
  squares, F statistics, partial R-squared and P values, based on 999
  permutations.
}
\description{
An R-based implementation of the NMIT, a multivariate distance-based test for
group comparisons of microbial temporal interdependence. The NMIT test
provides a comprehensive way to evaluate the association between key
phenotypic variables and microbial interdependence. This function is
recommended for use after a filtering step using
\code{filter_MAE}. Note, the "ComplexHeatmap" package is required to
use the plotting features of the function. The function requires the
"vegan" package.
}
\examples{
dat <- system.file("extdata/MAE_small.RDS", package = "LegATo") |> readRDS()
NMIT(dat, unit_var = "Subject", fixed_cov = "Group", covariate_time = "Month")

}
\author{
Yilong Zhang, Huilin Li, Aubrey Odom
}
