% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi0_estimators.R
\name{tst_pi0_est}
\alias{tst_pi0_est}
\title{TST (Two-Step) pi0 estimator}
\usage{
tst_pi0_est(pvalue, alpha)
}
\arguments{
\item{pvalue}{Numeric vector of unadjusted p-values.}

\item{alpha}{Nominal level for applying the TST procedure}
}
\value{
estimated proportion of null hypotheses (pi0)
}
\description{
TST (Two-Step) pi0 estimator
}
\examples{
     sim_df <- du_ttest_sim(20000,0.95, 1.5)
     tst_pi0_est(sim_df$pvalue, .1)

}
