% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kable_one.R
\name{kable_one}
\alias{kable_one}
\title{Produce a summary HTML table of key demographic variables}
\usage{
kable_one(x, significant_figures = 2)
}
\arguments{
\item{x}{A \code{data.frame} object or a named \code{list} of
\code{data.frame} objects returned from the \code{\link{table_one}} method}

\item{significant_figures}{The number of significant figures to be used for
decimals in the \code{HTML} table; if no value is specified, the default is 2}
}
\value{
A summary \code{HTML} table of key demographic variables
}
\description{
Sometimes it is desirable to produce a summary of key demographic variables
for presentation. The \code{\link{table_one}} and \code{\link{kable_one}}
methods are a quick way to do so – they not only summarize key demographic
variables from \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}
object(s) in the \code{\link{HMP16SData}} package but remove abbreviations
and underscores in column and variable names that might otherwise be
ambigious. The \code{\link{table_one}} method returns a \emph{tidy} (i.e. one
sample observation per line) \code{data.frame} object or a named \code{list}
of \emph{tidy} \code{data.frame} objects. The \code{\link{kable_one}} method
can then be used to produce a publication-ready \code{HTML} table that could,
for example, be pasted into a word processor.
}
\examples{
V13() \%>\%
    table_one() \%>\%
    kable_one()

}
\seealso{
\code{\link{table_one}}
}
