### R code from vignette source 'src/sec14_table.Rnw'

###################################################
### code chunk number 1: mainResultTable1
###################################################
library("HD2013SGI")

data("Interactions",package="HD2013SGI")

dir.create(file.path("result","Tables"),
           recursive=TRUE,showWarnings=FALSE)


###################################################
### code chunk number 2: mainResultTable2
###################################################
PI = Interactions$piscore
PI = (PI[,,,,,1] + PI[,,,,,2])/2
PADJ = Interactions$padj
PI[is.na(PADJ)] = NA


###################################################
### code chunk number 3: mainResultTable2
###################################################
dim(PI) = c(prod(dim(PI)[1:4]),dim(PI)[5])
dim(PADJ) = c(prod(dim(PADJ)[1:4]),dim(PADJ)[5])


###################################################
### code chunk number 4: mainResultTable3
###################################################
V = cbind(PI, PADJ)
V = V[,rep(seq_len(dim(PI)[2]),each=2)+rep(c(0,dim(PI)[2]),times=dim(PI)[2])]
colnames(V) = sprintf("%s.%s",rep(c("pi-score","padj"),times=dim(PI)[2]),
        rep(HD2013SGI:::humanReadableNames[ Interactions$Anno$phenotype ],
                          each=2))


###################################################
### code chunk number 5: mainResultTable4
###################################################
target =       rep(Interactions$Anno$target$Symbol,
                   times=prod(dim(Interactions$piscore)[c(2,3,4)]))
targetDesign = rep(rep(c("#1","#2"),
                   times=prod(dim(Interactions$piscore)[c(3,4)])),
                   each=dim(Interactions$piscore)[1])
query =        rep(rep(Interactions$Anno$query$Symbol,
                   times=dim(Interactions$piscore)[4]),
                   each=prod(dim(Interactions$piscore)[c(1,2)]))
queryDesign =  rep(c("#1","#2"),
                   each=prod(dim(Interactions$piscore)[c(1,2,3)]))

df =  data.frame(targetGene=target, targetDesign = targetDesign,
                 queryGene=query, queryDesign=queryDesign,
                 V)

write.table(df, file=file.path("result","Tables","interactions.txt"),sep="\t",
            row.names=FALSE,quote=FALSE)


