### R code from vignette source 'src/sec09_heatmaps.Rnw'

###################################################
### code chunk number 1: heatmap1
###################################################
library("HD2013SGI")

data("Interactions",package="HD2013SGI")
data("mainEffects",package="HD2013SGI")
data("nrOfInteractionsPerTarget",package="HD2013SGI")

dir.create(file.path("result","Figures"), recursive=TRUE)


###################################################
### code chunk number 2: heatmap2
###################################################
PI = Interactions$piscore
for (k in seq_len(dim(PI)[5])) {
  PI[,,,,k,] = PI[,,,,k,] / Interactions$scale[k]
}
PI = (PI[,,,,,1]+PI[,,,,,2]) / 2


###################################################
### code chunk number 3: heatmap3
###################################################
dim(PI) = c(prod(dim(PI)[1:2]),prod(dim(PI)[3:4]),dim(PI)[5])
dimnames(PI) = list(
  sprintf("%s_%d",rep(Interactions$Anno$target$Symbol,times=2),
          rep(seq_len(dim(Interactions$piscore)[2]),
              each=dim(Interactions$piscore)[1])),
  sprintf("%s_%d",rep(Interactions$Anno$query$Symbol,times=2),
          rep(seq_len(dim(Interactions$piscore)[4]),
              each=dim(Interactions$piscore)[3])),
  rep(dimnames(Interactions$piscore)[[5]]))


###################################################
### code chunk number 4: heatmap4
###################################################
cuts = c(-Inf,
         seq(-6, -2, length.out=(length(HD2013SGI:::colBY)-3)/2),
         0,
         seq( 2,  6, length.out=(length(HD2013SGI:::colBY)-3)/2),
         +Inf)


###################################################
### code chunk number 5: heatmap5
###################################################
pdf(file=file.path("result","Figures","heatmapAll.pdf"),height=14,width=9)


###################################################
### code chunk number 6: heatmap6
###################################################
I = HD2013SGIorderDim(PI,1)$order
J = HD2013SGIorderDim(PI,2)$order
K = HD2013SGIorderDim(PI,3)$order
HD2013SGIHeatmapHuman(x=PI[I,J,K],cuts=cuts,col=HD2013SGI:::colBY,
               colnames=TRUE,mcol=10,cexcol=0.5,mrow=0)


###################################################
### code chunk number 7: heatmap7
###################################################
dev.off()


###################################################
### code chunk number 8: heatmap8
###################################################
PI = Interactions$piscore
for (k in seq_len(dim(PI)[5])) {
  PI[,,,,k,] = PI[,,,,k,] / Interactions$scale[k]
}
PI = (PI[,,,,,1]+PI[,,,,,2]) / 2
PI = (PI[,1,,1,] + PI[,2,,1,] + PI[,1,,2,] + PI[,2,,2,])/4


###################################################
### code chunk number 9: heatmap9
###################################################
sel = which(nrOfInteractionsPerTarget >= 5)
PI = PI[sel,,]


###################################################
### code chunk number 10: heatmap10
###################################################
hcAll = HD2013SGIorderDim(PI,1)
dim(PI) = c(dim(PI)[1],prod(dim(PI)[2:3]))
dimnames(PI)[[1]] = Interactions$Anno$target$Symbol[sel]
C2 = cor(t(PI),use="pairwise.complete")


###################################################
### code chunk number 11: heatmap11
###################################################
pdf(file.path("result","Figures","heatmapSelection.pdf"))


###################################################
### code chunk number 12: heatmap12
###################################################
dd = as.dendrogram(hcAll)
heatmap.2(C2, col=colorRampPalette(brewer.pal(9,"RdBu"))(255),
          breaks=seq(-1,1,length.out=256),
          trace="none",Rowv=dd,Colv=dd)


###################################################
### code chunk number 13: heatmap13
###################################################
dev.off()


