### R code from vignette source 'src/sec08_siRNAcorrelation.Rnw'

###################################################
### code chunk number 1: siRNAcorrelation1
###################################################
library("HD2013SGI")

data("Interactions",package="HD2013SGI")
data("mainEffects",package="HD2013SGI")

dir.create(file.path("result","Figures"), recursive=TRUE)
dir.create(file.path("result","data"), recursive=TRUE)


###################################################
### code chunk number 2: siRNAcorrelation2
###################################################
PI = Interactions$piscore
for (k in seq_len(dim(PI)[5])) {
  PI[,,,,k,] = PI[,,,,k,] / Interactions$scale[k]
}
PI = (PI[,,,,,1]+PI[,,,,,2]) / 2
PI[is.na(Interactions$padj)] = NA_real_
PI2 = PI
dim(PI2) = c(prod(dim(PI)[1:2]),prod(dim(PI)[3:5]))
C = cor(t(PI2),use="pairwise.complete")


###################################################
### code chunk number 3: siRNAcorrelation3
###################################################
IDX = matrix(NA_integer_, nr=dim(Interactions$piscore)[1],nc=2)
IDX[,1] = seq_len(dim(Interactions$piscore)[1])
IDX[,2] = IDX[,1] + dim(Interactions$piscore)[1]
cc = C[IDX]


###################################################
### code chunk number 4: siRNAcorrelation4
###################################################
PI3 = PI
dim(PI3) = c(dim(PI)[1],dim(PI)[2],prod(dim(PI)[3:5]))
PI3[abs(PI3) < 5] = NA_real_
S = sign(PI3)
nrOfInteractionsPerTarget = apply(!is.na(S[,1,] == S[,2,]),1,sum,na.rm=TRUE)


###################################################
### code chunk number 5: siRNAcorrelation5
###################################################
differentGenes = upper.tri(C)
differentGenes[IDX] = FALSE
differentGenes[IDX[,2:1]] = FALSE
sel = which(nrOfInteractionsPerTarget >= 5)


###################################################
### code chunk number 6: siRNAcorrelation6
###################################################
pdf(file.path("result","Figures","multidensityWithinDesignCorrelation.pdf"),
    height=5)


###################################################
### code chunk number 7: siRNAcorrelation7
###################################################
multidensity(list(againstDifferentGenes = C[differentGenes],
                  againstSameGene = cc[sel]),
             legend = list(
               x = "topleft",
               legend = c("siRNA against different genes",
                          "siRNA against same gene"),
               fill = brewer.pal(9,"Set1")[1:2],bty="n"),
             xlim=c(-1,1),xlab="Correlation between siRNA designs",lwd=3)
rug(cc[sel])


###################################################
### code chunk number 8: siRNAcorrelation8
###################################################
dev.off()


###################################################
### code chunk number 9: siRNAcorrelation9
###################################################
save(nrOfInteractionsPerTarget,
     file=file.path("result","data","nrOfInteractionsPerTarget.rda"))


