\name{orcPeaks}
\alias{orcPeaksRep1}
\alias{orcPeaksRep2}
\docType{data}
\title{
Peaks from ChIP-seq alignments to yeast chromosome XIV
}
\description{
Peaks on yeast chromosome XIV of ChIP-seq data of ORC-binding sites in
yeast from Eaton et al. 2010
}
\usage{
data(orcPeaksRep1)
data(orcPeaksRep2)
}
\details{
This is the subset of Saccharomyces cerevisiae chromosome XIV peaks from
two ChIP-seq replicates of a origin recognition complex (ORC) binding
experiment.
}
\source{
ChIP-seq peaks extracted from
\url{ftp://ftp.ncbi.nih.gov/pub/geo/DATA/supplementary/samples/GSM424nnn/GSM424494/GSM424494_wt_G2_orc_chip_rep1.bed.gz}
and
\url{ftp://ftp.ncbi.nih.gov/pub/geo/DATA/supplementary/samples/GSM424nnn/GSM424494/GSM424494_wt_G2_orc_chip_rep2.bed.gz}
}
\references{
Conserved nucleosome positioning defines replication origins.
Eaton ML, Galani K, Kang S, Bell SP, MacAlpine DM.
Genes Dev. 2010 Apr 15;24(8):748-53.
}
\examples{
data(orcPeaksRep1)
data(orcPeaksRep2)
}
\keyword{datasets}
