% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELMER.data.R
\docType{package}
\name{ELMER.data}
\alias{ELMER.data}
\alias{ELMER.data-package}
\title{Data for ELMER package}
\description{
ELMER is package using DNA methylation to 
identify enhancers, and correlates enhancer state with expression of nearby genes 
to identify one or more transcriptional targets. Transcription factor (TF) binding 
site analysis of enhancers is coupled with expression analysis of all TFs to 
infer upstream regulators. ELMER.data provide the necessary data for 
ELMER analysis:
\itemize{
  \item Probes.motif: motif occurences within -/+250bp of probe sites on HM450K/EPIC array aligned against hg19/hg38.
  \item DNA methylation platform manifest: from http://zwdzwd.github.io/InfiniumAnnotation
  \item TF.family TFs family from TFClass  
  \item TF.subfamily TFs subfamily from TFClass  
}
For more information how to create these objects please read the vignette of this package with the
follwing command: \code{browseVignettes("ELMER.data")}
}
\examples{
# Please see the datasets
}
\seealso{
\code{\link[ELMER.data]{EPIC.hg19.manifest}}, \code{\link[ELMER.data]{EPIC.hg38.manifest}}, 
\code{\link[ELMER.data]{hm450.hg19.manifest}}, \code{\link[ELMER.data]{hm450.hg38.manifest}}, 
\code{\link[ELMER.data]{Probes.motif.hg19.450K}}, \code{\link[ELMER.data]{Probes.motif.hg38.450K}}, 
\code{\link[ELMER.data]{Probes.motif.hg38.EPIC}}, \code{\link[ELMER.data]{Probes.motif.hg19.EPIC}}, 
\code{\link[ELMER.data]{Human_genes__GRCh37_p13__tss}}, \code{\link[ELMER.data]{Human_genes__GRCh37_p13}},
\code{\link[ELMER.data]{Human_genes__GRCh38_p12}}, \code{\link[ELMER.data]{Human_genes__GRCh38_p12__tss}},
\code{\link[ELMER.data]{TF.subfamily}}, \code{\link[ELMER.data]{TF.family}}, and \code{\link[ELMER.data]{hocomoco.table}}
}
\keyword{utilities}
