% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnv.R
\name{getHEK293GenomeTrack}
\alias{getHEK293GenomeTrack}
\title{Obtain HEK293 genome data}
\usage{
getHEK293GenomeTrack(
  track = c("cnv.hmm", "cnv.snp"),
  cell.line = "293T",
  cache = TRUE
)
}
\arguments{
\item{track}{character. Genome track to retrieve. Valid options include:
\itemize{
\item \code{"cnvhmm"}: regions of copy number variation (CNV) as inferred by
a hidden Markov model (HMM) algorithm,
\item \code{"cnvsnp"}: CNV regions as inferred from Illumina SNP arrays
}
Defaults to \code{"cnvhmm"}.}

\item{cell.line}{character. Valid options include:
\itemize{
\item \code{"293T"}: highly-transfective derivative of human embryonic kidney
293 cell line,
}
Defaults to \code{"293T"}.}

\item{cache}{logical. Should a locally cached version used if available?
Defaults to \code{TRUE}.}
}
\value{
A \code{GRanges} object storing genomic coordinates and genomic scores
of regions of interest.
}
\description{
Functionality for retrieving genomic data for different
lineages of the human embryonic kidney HEK293 cell line.
Returned genomic coordinates are based on the \emph{hg18} human genome assembly.
See references.
}
\examples{
   cnv.hmm <- getHEK293GenomeTrack(track = "cnv.hmm", cell.line = "293T")

}
\references{
\url{http://hek293genome.org}
}
