% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corum.R
\name{getCorum}
\alias{getCorum}
\title{Obtain CORUM protein complex data}
\usage{
getCorum(
  set = c("all", "core", "splice"),
  organism = "Human",
  remap.uniprot.ids = FALSE,
  cache = TRUE,
  mode = c("ehub", "web")
)
}
\arguments{
\item{set}{character. Valid options include:
\itemize{
\item \code{"all"}: complete set of complexes,
\item \code{"core"}: core set of complexes,
\item \code{"splice"}: complexes with splice variants.
}
Defaults to \code{"all"}.}

\item{organism}{character. Use \code{NULL} to not subset by organism.
Defaults to \code{"Human"} which restricts the data to human protein complexes
only.}

\item{remap.uniprot.ids}{logical. Should the protein-to-gene mappings from CORUM
(i.e. UNIPROT-to-SYMBOL and UNIPROT-to-ENTREZID) be updated using Bioc annotation
functionality? Currently only supported in combination with \code{organism = "Human"}.
Defaults to \code{FALSE} which will then keep the mappings provided by CORUM.}

\item{cache}{logical. Should a locally cached version used if available?
Defaults to \code{TRUE}.}

\item{mode}{character. Should CORUM complexes be obtained from ExperimentHub
or via a web download from the CORUM homepage? Defaults to \code{"ehub"},
which will obtain the chosen complex set from ExperimentHub.}
}
\value{
A \code{data.frame}.
}
\description{
Functionality for retrieving the CORUM protein complex data.
Available complex collections include:
\itemize{
\item complete set of complexes,
\item core set of complexes,
\item complexes with splice variants.
} See references.
}
\examples{
# Obtain the core set of CORUM complexes
core <- getCorum(set = "core")
}
\references{
CORUM: \url{http://mips.helmholtz-muenchen.de/corum/#download}
}
