% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutations.R
\name{getMutations4DiseaseByIDs}
\alias{getMutations4DiseaseByIDs}
\title{Get mutational information for Gene and Disease}
\usage{
getMutations4DiseaseByIDs(ids, hdoid)
}
\arguments{
\item{ids}{internal GeneIDs to filter mutation data}

\item{hdoid}{disease HDOID to get mutational association.}
}
\value{
\code{data.frame} with fields specified above.
}
\description{
Function looks up the information for particular set of GeneIDs
and disease HDOID.
}
\details{
This function then returns
following features for all found genes:
\itemize{
\item GeneID,
\item MGI,
\item MouseEntrez,
\item MouseName,
\item HumanName,
\item HumanEntrez,
\item HDOID,
\item Disease,
\item Chromosome,
\item Position,
\item Variant,
\item FunctionClass,
\item cDNAvariant,
\item ProteinVariant,
\item DENOVO,
\item SFARI,
\item EpilepsyGene,
\item ClinVar,
\item PMID,
\item Paper
}
}
\examples{
hdoid<-'DOID:0060041'
ids<-c(6,32,127,181,240,267,558)
mdf<-getMutations4DiseaseByIDs(ids, hdoid)
is.null(mdf)
}
\seealso{
Other {Mutation functions}: 
\code{\link{getMutations4DiseaseByEntres}()},
\code{\link{getMutations4DiseaseByName}()}
}
\concept{{Mutation functions}}
