% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInfo.R
\name{getGenesByID}
\alias{getGenesByID}
\title{Get gene table from list of GeneIDs.}
\usage{
getGenesByID(ids)
}
\arguments{
\item{ids}{\code{vector} of GeneID values.}
}
\value{
\code{data.frame} with 8 columns specified above.
}
\description{
Takes internal gene IDs as input and return the following features for
all found genes:
\describe{
\item{GeneID}{ internal database ID}
\item{MGI}{ MGI ID}
\item{HumanEntrez}{Human Entrez ID}
\item{MouseEntrez}{Mouse Entrez ID}
\item{HumanName}{Human gene name}
\item{MouseName}{Mouse gene name}
\item{RatEntrez}{Rat Entrez ID}
\item{Rat Name}{Rat gene name}
}
}
\examples{
gdf <- getGenesByID(c(46, 6, 15, 1))
}
\seealso{
Other {Gene functions}: 
\code{\link{findGeneByCompartmentPaperCnt}()},
\code{\link{findGeneByPaperCnt}()},
\code{\link{findGeneByPapers}()},
\code{\link{findGenesByEntrez}()},
\code{\link{findGenesByName}()},
\code{\link{getAllGenes4Compartment}()},
\code{\link{getGenes4Compartment}()}
}
\concept{{Gene functions}}
