datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Dr.eg <- function() showQCData("org.Dr.eg", datacache)
org.Dr.eg_dbconn <- function() dbconn(datacache)
org.Dr.eg_dbfile <- function() dbfile(datacache)
org.Dr.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Dr.eg_dbInfo <- function() dbInfo(datacache)

org.Dr.egORGANISM <- "Danio rerio"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Dr.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("ZEBRAFISH_DB", "org.Dr.eg", "Zebrafish", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Dr.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Dr.eg_dbconn())
}

