getJoinCompatible = function() {
    withCallingHandlers({
        data("gwrngs19", package="gwascat", envir=environment())
    }, warning=function(...) {
        stop("package 'gwascat' required but not installed")
    })
    gr <- gwrngs19
    seqlevelsStyle(gr) = "NCBI"
    gr$chr_hg19 = as.character(seqnames(gr))
    gr$pos_hg19 = as.integer(start(gr))
    unique(gr)
}

checkAnti = function(chr) {
    chr = as.character(chr)
    gg = getJoinCompatible()

    gwas <- tbl_df(as(gg, "data.frame"))  %>% filter(seqnames==chr)
    grasp <- tbl(GRASP2(), "variant") %>% filter(chr_hg19 == chr) %>%
        as.data.frame(n=Inf) %>% tbl_df
    anti_join(gwas, grasp, by="pos_hg19")
}
