### =========================================================================
### CTCF metadata
### -------------------------------------------------------------------------
###

meta <- data.frame(
    Title = c("T2T.CIS_BP_2.00_Homo_sapiens.RData", "T2T.CTCFBSDB_PWM.RData", "T2T.HOCOMOCOv11_core_HUMAN_mono_meme_format.RData", "T2T.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "T2T.Jolma2013.RData", "T2T.MA0139.1.RData", "T2T.SwissRegulon_human_and_mouse.RData", "hg38.CIS_BP_2.00_Homo_sapiens.RData", "hg38.CTCFBSDB.CTCF_predicted_human.RData", "hg38.CTCFBSDB_PWM.RData", "hg38.HOCOMOCOv11_core_HUMAN_mono_meme_format.RData", "hg38.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "hg38.Jolma2013.RData", "hg38.MA0139.1.RData", "hg38.SCREEN.GRCh38_CTCF.RData", "hg38.SwissRegulon_human_and_mouse.RData", "hg19.CIS_BP_2.00_Homo_sapiens.RData", "hg19.CTCFBSDB.CTCF_predicted_human.RData", "hg19.CTCFBSDB_PWM.RData", "hg19.HOCOMOCOv11_core_HUMAN_mono_meme_format.RData", "hg19.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "hg19.Jolma2013.RData", "hg19.MA0139.1.RData", "hg19.SwissRegulon_human_and_mouse.RData", "hg18.CTCFBSDB.CTCF_predicted_human.RData", "hg18.MA0139.1.RData", "mm39.CIS_BP_2.00_Mus_musculus.RData", "mm39.CTCFBSDB_PWM.RData", "mm39.HOCOMOCOv11_core_MOUSE_mono_meme_format.RData", "mm39.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "mm39.Jolma2013.RData", "mm39.MA0139.1.RData", "mm39.SwissRegulon_human_and_mouse.RData", "mm10.CIS_BP_2.00_Mus_musculus.RData", "mm10.CTCFBSDB.CTCF_predicted_mouse.RData", "mm10.CTCFBSDB_PWM.RData", "mm10.HOCOMOCOv11_core_MOUSE_mono_meme_format.RData", "mm10.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "mm10.Jolma2013.RData", "mm10.MA0139.1.RData", "mm10.SCREEN.mm10_CTCF.RData", "mm10.SwissRegulon_human_and_mouse.RData", "mm9.CIS_BP_2.00_Mus_musculus.RData", "mm9.CTCFBSDB.CTCF_predicted_mouse.RData", "mm9.CTCFBSDB_PWM.RData", "mm9.HOCOMOCOv11_core_MOUSE_mono_meme_format.RData", "mm9.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "mm9.Jolma2013.RData", "mm9.MA0139.1.RData", "mm9.SwissRegulon_human_and_mouse.RData", "mm8.CTCFBSDB.CTCF_predicted_mouse.RData"),
    Description = c("T2T CTCF motifs detected using human PWM matrices from http://cisbp.ccbr.utoronto.ca/, by FIMO",
                    "T2T CTCF motifs detected using PWM matrices from https://insulatordb.uthsc.edu/, by FIMO",
                    "T2T CTCF motifs detected using human PWM matrices from https://hocomoco11.autosome.org/, by FIMO",
                    "T2T CTCF motifs detected using human PWM matrices from https://jaspar.genereg.net/, by FIMO",
                    "T2T CTCF motifs detected using PWM matrices from DOI:10.1016/j.cell.2012.12.009, by FIMO",
                    "T2T CTCF motifs detected using MA0139.1 PWM matrix from https://jaspar.genereg.net/, by FIMO",
                    "T2T CTCF motifs detected using PWM matrices from https://swissregulon.unibas.ch/sr/, by FIMO",
                    "hg38 CTCF motifs detected using human PWM matrices from http://cisbp.ccbr.utoronto.ca/, by FIMO",
                    "hg38 CTCF predicted motifs from https://insulatordb.uthsc.edu/",
                    "hg38 CTCF motifs detected using PWM matrices from https://insulatordb.uthsc.edu/, by FIMO",
                    "hg38 CTCF motifs detected using human PWM matrices from https://hocomoco11.autosome.org/, by FIMO",
                    "hg38 CTCF motifs detected using human PWM matrices from https://jaspar.genereg.net/, by FIMO",
                    "hg38 CTCF motifs detected using PWM matrices from DOI:10.1016/j.cell.2012.12.009, by FIMO",
                    "hg38 CTCF motifs detected using MA0139.1 PWM matrix from https://jaspar.genereg.net/, by FIMO",
                    "hg38 CTCF-bound human cis-regulatory elements from https://screen.encodeproject.org/",
                    "hg38 CTCF motifs detected using PWM matrices from https://swissregulon.unibas.ch/sr/, by FIMO",
                    "hg19 CTCF motifs detected using human PWM matrices from http://cisbp.ccbr.utoronto.ca/, by FIMO",
                    "hg19 CTCF motifs detected using PWM matrices from https://insulatordb.uthsc.edu/, by FIMO",
                    "hg19 CTCF predicted motifs from https://insulatordb.uthsc.edu/",
                    "hg19 CTCF motifs detected using human PWM matrices from https://hocomoco11.autosome.org/, by FIMO",
                    "hg19 CTCF motifs detected using human PWM matrices from https://jaspar.genereg.net/, by FIMO",
                    "hg19 CTCF motifs detected using PWM matrices from DOI:10.1016/j.cell.2012.12.009, by FIMO",
                    "hg19 CTCF motifs detected using MA0139.1 PWM matrix from https://jaspar.genereg.net/, by FIMO",
                    "hg19 CTCF motifs detected using PWM matrices from https://swissregulon.unibas.ch/sr/, by FIMO",
                    "hg18 CTCF predicted motifs from https://insulatordb.uthsc.edu/",
                    "hg18 CTCF motifs detected using MA0139.1 PWM matrix from https://jaspar.genereg.net/, by FIMO",
                    "mm39 CTCF motifs detected using mouse PWM matrices from http://cisbp.ccbr.utoronto.ca/, by FIMO",
                    "mm39 CTCF predicted motifs from https://insulatordb.uthsc.edu/",
                    "mm39 CTCF motifs detected using mouse PWM matrices from https://hocomoco11.autosome.org/, by FIMO",
                    "mm39 CTCF motifs detected using mouse PWM matrices from https://jaspar.genereg.net/, by FIMO",
                    "mm39 CTCF motifs detected using PWM matrices from DOI:10.1016/j.cell.2012.12.009, by FIMO",
                    "mm39 CTCF motifs detected using MA0139.1 PWM matrix from https://jaspar.genereg.net/, by FIMO",
                    "mm39 CTCF motifs detected using PWM matrices from https://swissregulon.unibas.ch/sr/, by FIMO",
                    "mm10 CTCF motifs detected using mouse PWM matrices from http://cisbp.ccbr.utoronto.ca/, by FIMO",
                    "mm10 CTCF motifs detected using PWM matrices from https://insulatordb.uthsc.edu/, by FIMO",
                    "mm10 CTCF predicted motifs from https://insulatordb.uthsc.edu/",
                    "mm10 CTCF motifs detected using mouse PWM matrices from https://hocomoco11.autosome.org/, by FIMO",
                    "mm10 CTCF motifs detected using mouse PWM matrices from https://jaspar.genereg.net/, by FIMO",
                    "mm10 CTCF motifs detected using PWM matrices from DOI:10.1016/j.cell.2012.12.009, by FIMO",
                    "mm10 CTCF motifs detected using MA0139.1 PWM matrix from https://jaspar.genereg.net/, by FIMO",
                    "mm10 CTCF-bound mouse cis-regulatory elements from https://screen.encodeproject.org/",
                    "mm10 CTCF motifs detected using PWM matrices from https://swissregulon.unibas.ch/sr/, by FIMO",
                    "mm9 CTCF motifs detected using mouse PWM matrices from http://cisbp.ccbr.utoronto.ca/, by FIMO",
                    "mm9 CTCF motifs detected using PWM matrices from https://insulatordb.uthsc.edu/, by FIMO",
                    "mm9 CTCF predicted motifs from https://insulatordb.uthsc.edu/",
                    "mm9 CTCF motifs detected using mouse PWM matrices from https://hocomoco11.autosome.org/, by FIMO",
                    "mm9 CTCF motifs detected using mouse PWM matrices from https://jaspar.genereg.net/, by FIMO",
                    "mm9 CTCF motifs detected using PWM matrices from DOI:10.1016/j.cell.2012.12.009, by FIMO",
                    "mm9 CTCF motifs detected using MA0139.1 PWM matrix from https://jaspar.genereg.net/, by FIMO",
                    "mm9 CTCF motifs detected using PWM matrices from https://swissregulon.unibas.ch/sr/, by FIMO",
                    "mm8 CTCF predicted motifs from https://insulatordb.uthsc.edu/"),
    BiocVersion = rep("3.15", 51),
    Genome = c("T2T", "T2T", "T2T", "T2T", "T2T", "T2T", "T2T", "hg38", "hg38", "hg38", "hg38", "hg38", "hg38", "hg38", "hg38", "hg38", "hg19", "hg19", "hg19", "hg19", "hg19", "hg19", "hg19", "hg19", "hg18", "hg18", "mm39", "mm39", "mm39", "mm39", "mm39", "mm39", "mm39", "mm10", "mm10", "mm10", "mm10", "mm10", "mm10", "mm10", "mm10", "mm10", "mm9", "mm9", "mm9", "mm9", "mm9", "mm9", "mm9", "mm9", "mm8"),
    SourceType = rep("RData", 51),
    SourceUrl = rep("https://drive.google.com/drive/folders/19ZXr7IETfks0OdYlmuc1Hqe700Pw3jPc?usp=sharing", 51),
    SourceVersion = rep("July 20 2022", 51),
    Species = c("Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Homo sapiens", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus", "Mus musculus"),
    TaxonomyId = c(9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 9606, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090, 10090),
    Coordinate_1_based = rep(TRUE, 51),
    DataProvider = c("CIS-BP", "CTCFBSDB 2.0", "HOCOMOCO v11", "JASPAR 2022", "Jolma 2013", "JASPAR 2022", "SwissRegulon", "CIS-BP", "CTCFBSDB 2.0", "CTCFBSDB 2.0", "HOCOMOCO v11", "JASPAR 2022", "Jolma 2013", "JASPAR 2022", "ENCODE SCREEN v3", "SwissRegulon", "CIS-BP", "CTCFBSDB 2.0", "CTCFBSDB 2.0", "HOCOMOCO v11", "JASPAR 2022", "Jolma 2013", "JASPAR 2022", "SwissRegulon", "CTCFBSDB 2.0", "JASPAR 2022", "CIS-BP", "CTCFBSDB 2.0", "HOCOMOCO v11", "JASPAR 2022", "Jolma 2013", "JASPAR 2022", "SwissRegulon", "CIS-BP", "CTCFBSDB 2.0", "CTCFBSDB 2.0", "HOCOMOCO v11", "JASPAR 2022", "Jolma 2013", "JASPAR 2022", "ENCODE SCREEN v3", "SwissRegulon", "CIS-BP", "CTCFBSDB 2.0", "CTCFBSDB 2.0", "HOCOMOCO v11", "JASPAR 2022", "Jolma 2013", "JASPAR 2022", "SwissRegulon", "CTCFBSDB 2.0"),
    Maintainer = rep("Mikhail Dozmorov <mikhail.dozmorov@gmail.com>", 51),
    RDataClass = rep("GRanges", 51),
    DispatchClass = rep("Rda", 51),
    RDataPath = c("CTCF/T2T.CIS_BP_2.00_Homo_sapiens.RData", "CTCF/T2T.CTCFBSDB_PWM.RData", "CTCF/T2T.HOCOMOCOv11_core_HUMAN_mono_meme_format.RData", "CTCF/T2T.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "CTCF/T2T.Jolma2013.RData", "CTCF/T2T.MA0139.1.RData", "CTCF/T2T.SwissRegulon_human_and_mouse.RData", "CTCF/hg38.CIS_BP_2.00_Homo_sapiens.RData", "CTCF/hg38.CTCFBSDB.CTCF_predicted_human.RData", "CTCF/hg38.CTCFBSDB_PWM.RData", "CTCF/hg38.HOCOMOCOv11_core_HUMAN_mono_meme_format.RData", "CTCF/hg38.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "CTCF/hg38.Jolma2013.RData", "CTCF/hg38.MA0139.1.RData", "CTCF/hg38.SCREEN.GRCh38_CTCF.RData", "CTCF/hg38.SwissRegulon_human_and_mouse.RData", "CTCF/hg19.CIS_BP_2.00_Homo_sapiens.RData", "CTCF/hg19.CTCFBSDB.CTCF_predicted_human.RData", "CTCF/hg19.CTCFBSDB_PWM.RData", "CTCF/hg19.HOCOMOCOv11_core_HUMAN_mono_meme_format.RData", "CTCF/hg19.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "CTCF/hg19.Jolma2013.RData", "CTCF/hg19.MA0139.1.RData", "CTCF/hg19.SwissRegulon_human_and_mouse.RData", "CTCF/hg18.CTCFBSDB.CTCF_predicted_human.RData", "CTCF/hg18.MA0139.1.RData", "CTCF/mm39.CIS_BP_2.00_Mus_musculus.RData", "CTCF/mm39.CTCFBSDB_PWM.RData", "CTCF/mm39.HOCOMOCOv11_core_MOUSE_mono_meme_format.RData", "CTCF/mm39.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "CTCF/mm39.Jolma2013.RData", "CTCF/mm39.MA0139.1.RData", "CTCF/mm39.SwissRegulon_human_and_mouse.RData", "CTCF/mm10.CIS_BP_2.00_Mus_musculus.RData", "CTCF/mm10.CTCFBSDB.CTCF_predicted_mouse.RData", "CTCF/mm10.CTCFBSDB_PWM.RData", "CTCF/mm10.HOCOMOCOv11_core_MOUSE_mono_meme_format.RData", "CTCF/mm10.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "CTCF/mm10.Jolma2013.RData", "CTCF/mm10.MA0139.1.RData", "CTCF/mm10.SCREEN.mm10_CTCF.RData", "CTCF/mm10.SwissRegulon_human_and_mouse.RData", "CTCF/mm9.CIS_BP_2.00_Mus_musculus.RData", "CTCF/mm9.CTCFBSDB.CTCF_predicted_mouse.RData", "CTCF/mm9.CTCFBSDB_PWM.RData", "CTCF/mm9.HOCOMOCOv11_core_MOUSE_mono_meme_format.RData", "CTCF/mm9.JASPAR2022_CORE_vertebrates_non_redundant_v2.RData", "CTCF/mm9.Jolma2013.RData", "CTCF/mm9.MA0139.1.RData", "CTCF/mm9.SwissRegulon_human_and_mouse.RData", "CTCF/mm8.CTCFBSDB.CTCF_predicted_mouse.RData"),
    Tags = rep("CTCF", 51),
    Notes = "")

write.csv(meta, file="inst/extdata/metadata.csv", row.names=FALSE)
