% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/helper_methods.R
\name{loglik}
\alias{loglik}
\alias{loglik,ZinbModel,matrix-method}
\title{Compute the log-likelihood of a model given some data}
\usage{
loglik(model, x, ...)

\S4method{loglik}{ZinbModel,matrix}(model, x)
}
\arguments{
\item{model}{an object that describes a statistical model.}

\item{x}{an object that describes data.}

\item{...}{additional arguments.}
}
\value{
The log-likelihood of the model given the data.
}
\description{
Given a statistical model and some data, this function computes the
log-likelihood of the model given the data, i.e., the log-probability of the
data under the model.
}
\section{Methods (by class)}{
\itemize{
\item \code{loglik(model = ZinbModel, x = matrix)}: return the log-likelihood of the ZINB model.

}}
\examples{
m <- zinbModel(n=5, J=10)
x <- zinbSim(m)
loglik(m, x$counts)
}
