% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCMDS.R
\name{plotCMDS}
\alias{plotCMDS}
\title{Plot classical MDS of dataset}
\usage{
plotCMDS(obj, comp = 1:2, normalized = FALSE, distFun = dist,
  distMethod = "euclidian", n = NULL, samples = TRUE, log = TRUE,
  plotFlag = TRUE, ...)
}
\arguments{
\item{obj}{ExpressionSet object or objrix.}

\item{comp}{Which components to display.}

\item{normalized}{TRUE / FALSE, use the normalized matrix or raw counts.}

\item{distFun}{Distance function, default is dist.}

\item{distMethod}{The distance measure to be used. This must be one of "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski". Any unambiguous substring can be given.}

\item{n}{Number of features to make use of in calculating your distances.}

\item{samples}{Perform on samples or genes.}

\item{log}{TRUE/FALSE log2-transform raw counts.}

\item{plotFlag}{TRUE/FALSE whether to plot or not.}

\item{...}{Additional plot arguments.}
}
\value{
coordinates
}
\description{
This function plots the MDS coordinates for the "n" features of interest. Potentially uncovering batch
effects or feature relationships.
}
\examples{
data(skin)
res <- plotCMDS(skin,pch=21,bg=factor(pData(skin)$SMTSD))
\donttest{
# library(calibrate)
# textxy(X=res[,1],Y=res[,2],labs=rownames(res))
}
}
