% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-Chromatogram.R,
%   R/methods-MChromatograms.R, R/methods-XChromatogram.R
\name{removeIntensity,Chromatogram-method}
\alias{removeIntensity,Chromatogram-method}
\alias{removeIntensity}
\alias{removeIntensity,MChromatograms-method}
\alias{removeIntensity,XChromatogram-method}
\title{Remove intensities from chromatographic data}
\usage{
\S4method{removeIntensity}{Chromatogram}(object, which = "below_threshold", threshold = 0)

\S4method{removeIntensity}{MChromatograms}(object, which = "below_threshold", threshold = 0)

\S4method{removeIntensity}{XChromatogram}(
  object,
  which = c("below_threshold", "outside_chromPeak"),
  threshold = 0
)
}
\arguments{
\item{object}{an object representing chromatographic data. Can be a
\code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}}, \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}},
\code{\link[=XChromatogram]{XChromatogram()}} or \code{\link[=XChromatograms]{XChromatograms()}} object.}

\item{which}{\code{character(1)} defining the condition to remove intensities.
See description for details and options.}

\item{threshold}{\code{numeric(1)} defining the threshold below which intensities
are removed (if \code{which = "below_threshold"}).}
}
\value{
the input object with matching intensities being replaced by \code{NA}.
}
\description{
\code{removeIntensities} allows to remove intensities from chromatographic data
matching certain conditions (depending on parameter \code{which}). The
intensities are actually not \emph{removed} but replaced with \code{NA_real_}. To
actually \strong{remove} the intensities (and the associated retention times)
use \code{\link[MSnbase:clean-methods]{MSnbase::clean()}} afterwards.

Parameter \code{which} allows to specify which intensities should be replaced by
\code{NA_real_}. By default (\code{which = "below_threshod"} intensities below
\code{threshold} are removed. If \code{x} is a \code{XChromatogram} or \code{XChromatograms}
object (and hence provides also chromatographic peak definitions within the
object) \code{which = "outside_chromPeak"} can be selected which removes any
intensity which is outside the boundaries of identified chromatographic
peak(s) in the chromatographic data.

Note that \code{filterIntensity()} might be a better approach to
subset/filter chromatographic data.
}
\examples{

library(MSnbase)
chr <- Chromatogram(rtime = 1:10 + rnorm(n = 10, sd = 0.3),
    intensity = c(5, 29, 50, NA, 100, 12, 3, 4, 1, 3))

## Remove all intensities below 20
res <- removeIntensity(chr, threshold = 20)
intensity(res)
}
\author{
Johannes Rainer
}
