% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-XCMSnExp.R
\name{exportMetaboAnalyst}
\alias{exportMetaboAnalyst}
\title{Export data for use in MetaboAnalyst}
\usage{
exportMetaboAnalyst(
  x,
  file = NULL,
  label,
  value = "into",
  digits = NULL,
  groupnames = FALSE,
  ...
)
}
\arguments{
\item{x}{\link{XCMSnExp} object with identified chromatographic peaks grouped
across samples.}

\item{file}{\code{character(1)} defining the file name. If not specified, the
\code{matrix} with the content is returned.}

\item{label}{either \code{character(1)} specifying the phenodata column in \code{x}
defining the sample grouping or a vector with the same length than
samples in \code{x} defining the group assignment of the samples.}

\item{value}{\code{character(1)} specifying the value to be returned for each
feature. See \code{\link[=featureValues]{featureValues()}} for more details.}

\item{digits}{\code{integer(1)} defining the number of significant digits to be
used for numeric. The default \code{NULL} uses \code{getOption("digits")}. See
\code{\link[=format]{format()}} for more information.}

\item{groupnames}{\code{logical(1)} whether row names of the resulting matrix
should be the feature IDs (\code{groupnames = FALSE}; default) or IDs that
are composed of the m/z and retention time of the features (in the
format \verb{M<m/z>T<rt>} (\code{groupnames = TRUE}). See help of the \link{groupnames}
function for details.}

\item{...}{additional parameters to be passed to the \code{\link[=featureValues]{featureValues()}}
function.}
}
\value{
If \code{file} is not specified, the function returns the \code{matrix} in
the format supported by MetaboAnalyst.
}
\description{
Export the feature table for further analysis in the MetaboAnalyst
software (or the \code{MetaboAnalystR} R package).
}
\author{
Johannes Rainer
}
