% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_groupChromPeaks-functions.R
\name{do_groupChromPeaks_nearest}
\alias{do_groupChromPeaks_nearest}
\title{Core API function for chromatic peak grouping using a nearest
neighbor approach}
\usage{
do_groupChromPeaks_nearest(
  peaks,
  sampleGroups,
  mzVsRtBalance = 10,
  absMz = 0.2,
  absRt = 15,
  kNN = 10
)
}
\arguments{
\item{peaks}{A \code{matrix} or \code{data.frame} with the mz values and
retention times of the identified chromatographic peaks in all samples
of an experiment. Required columns are \code{"mz"}, \code{"rt"} and
\code{"sample"}. The latter should contain \code{numeric} values representing
the index of the sample in which the peak was found.}

\item{sampleGroups}{For \code{PeakDensityParam}: A vector of the same length than
samples defining the sample group assignments (i.e. which samples
belong to which sample group). This parameter is mandatory for
\code{PeakDensityParam} and has to be defined also if there is no sample
grouping in the experiment (in which case all samples should be
assigned to the same group). Samples for which a \code{NA} is provided will
not be considered in the feature definitions step. Providing \code{NA} for
all blanks in an experiment will for example avoid features to be
defined for signals (chrom peaks) present only in blank samples.}

\item{mzVsRtBalance}{For \code{NearestPeaksParam}: \code{numeric(1)} representing the
factor by which m/z values are multiplied before calculating the
(euclician) distance between two peaks.}

\item{absMz}{For \code{NearestPeaksParam} and \code{MzClustParam}: \code{numeric(1)}
maximum tolerated distance for m/z values.}

\item{absRt}{For \code{NearestPeaksParam}: \code{numeric(1)} maximum tolerated
distance for retention times.}

\item{kNN}{For \code{NearestPeaksParam}: \code{integer(1)} representing the number of
nearest neighbors to check.}
}
\value{
A \code{list} with elements \code{"featureDefinitions"} and
\code{"peakIndex"}. \code{"featureDefinitions"} is a \code{matrix}, each row
representing an (mz-rt) feature (i.e. peak group) with columns:
\itemize{
\item \code{"mzmed"}: median of the peaks' apex mz values.
\item \code{"mzmin"}: smallest mz value of all peaks' apex within the feature.
\item \code{"mzmax"}:largest mz value of all peaks' apex within the feature.
\item \code{"rtmed"}: the median of the peaks' retention times.
\item \code{"rtmin"}: the smallest retention time of the peaks in the feature.
\item \code{"rtmax"}: the largest retention time of the peaks in the feature.
\item \code{"npeaks"}: the total number of peaks assigned to the feature.
}

\code{"peakIndex"} is a \code{list} with the indices of all peaks in a feature in the
\code{peaks} input matrix.
}
\description{
The \code{do_groupChromPeaks_nearest} function groups peaks across samples by
creating a master peak list and assigning corresponding peaks from all
samples to each peak group (i.e. feature). The method is inspired by the
correspondence algorithm of mzMine (Katajamaa 2006).
}
\references{
Katajamaa M, Miettinen J, Oresic M: MZmine: Toolbox for
processing and visualization of mass spectrometry based molecular profile
data. Bioinformatics 2006, 22:634-636.
doi: \href{https://doi.org/10.1093/bioinformatics/btk039}{10.1093/bioinformatics/btk039}
}
\seealso{
Other core peak grouping algorithms: 
\code{\link{do_groupChromPeaks_density}()},
\code{\link{do_groupPeaks_mzClust}()}
}
\concept{core peak grouping algorithms}
