% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_adjustRtime-functions.R
\name{do_adjustRtime_peakGroups}
\alias{do_adjustRtime_peakGroups}
\title{Align spectrum retention times across samples using peak groups
found in most samples}
\usage{
do_adjustRtime_peakGroups(
  peaks,
  peakIndex,
  rtime = list(),
  minFraction = 0.9,
  extraPeaks = 1,
  smooth = c("loess", "linear"),
  span = 0.2,
  family = c("gaussian", "symmetric"),
  peakGroupsMatrix = matrix(ncol = 0, nrow = 0),
  subset = integer(),
  subsetAdjust = c("average", "previous")
)
}
\arguments{
\item{peaks}{a \code{matrix} or \code{data.frame} with the identified
chromatographic peaks in the samples.}

\item{peakIndex}{a \code{list} of indices that provides the grouping
information of the chromatographic peaks (across and within samples).}

\item{rtime}{a \code{list} of \code{numeric} vectors with the retention
times per file/sample.}

\item{minFraction}{For \code{PeakGroupsParam}: \code{numeric(1)} between 0 and 1
defining the minimum required proportion of samples in which peaks for
the peak group were identified. Peak groups passing this criteria will
be aligned across samples and retention times of individual spectra will
be adjusted based on this alignment. For \code{minFraction = 1} the peak
group has to contain peaks in all samples of the experiment. Note that if
\code{subset} is provided, the specified fraction is relative to the
defined subset of samples and not to the total number of samples within
the experiment (i.e., a peak has to be present in the specified
proportion of subset samples).}

\item{extraPeaks}{For \code{PeakGroupsParam}: \code{numeric(1)} defining the maximal
number of additional peaks for all
samples to be assigned to a peak group (feature) for retention time
correction. For a data set with 6 samples, \code{extraPeaks = 1} uses all
peak groups with a total peak count \verb{<= 6 + 1}. The total peak count
is the total number of peaks being assigned to a peak group and
considers also multiple peaks within a sample that are assigned to
the group. This parameter is ignored for \code{adjustRtime()} on an
\code{\link[=XcmsExperimentHdf5]{XcmsExperimentHdf5()}}.}

\item{smooth}{For \code{PeakGroupsParam}: \code{character(1)} defining the function to
be used to interpolate corrected retention times for all peak groups.
Can be either \code{"loess"} or \code{"linear"}.}

\item{span}{For \code{PeakGroupsParam}: \code{numeric(1)} defining
the degree of smoothing (if \code{smooth = "loess"}). This parameter is
passed to the internal call to \code{\link[stats:loess]{stats::loess()}}.}

\item{family}{For \code{PeakGroupsParam}: \code{character(1)} defining the method for
loess smoothing. Allowed values are \code{"gaussian"} and \code{"symmetric"}. See
\code{\link[stats:loess]{stats::loess()}} for more information.}

\item{peakGroupsMatrix}{optional \code{matrix} of (raw) retention times for
peak groups on which the alignment should be performed. Each column
represents a sample, each row a feature/peak group. If not provided,
this matrix will be determined depending on parameters
\code{minFraction} and \code{extraPeaks}. If provided,
\code{minFraction} and \code{extraPeaks} will be ignored.}

\item{subset}{For \code{ObiwarpParam} and \code{PeakGroupsParam}: \code{integer} with the
indices of samples within the experiment on which the alignment models
should be estimated.
Samples not part of the subset are adjusted based on the closest subset
sample. See \emph{Subset-based alignment} section for details.}

\item{subsetAdjust}{For \code{ObiwarpParam} and \code{PeakGroupsParam}: \code{character(1)}
specifying the method with which non-subset samples should be adjusted.
Supported options are \code{"previous"} and \code{"average"} (default).
See \emph{Subset-based alignment} section for details.}
}
\value{
A \code{list} with \code{numeric} vectors with the adjusted
retention times grouped by sample.
}
\description{
The function performs retention time correction by assessing
the retention time deviation across all samples using peak groups
(features) containg chromatographic peaks present in most/all samples.
The retention time deviation for these features in each sample is
described by fitting either a polynomial (\code{smooth = "loess"}) or
a linear (\code{smooth = "linear"}) model to the data points. The
models are subsequently used to adjust the retention time for each
spectrum in each sample.
}
\details{
The alignment bases on the presence of compounds that can be found
in all/most samples of an experiment. The retention times of individual
spectra are then adjusted based on the alignment of the features
corresponding to these \emph{house keeping compounds}. The parameters
\code{minFraction} and \code{extraPeaks} can be used to fine tune which
features should be used for the alignment (i.e. which features
most likely correspond to the above mentioned house keeping compounds).

Parameter \code{subset} allows to define a subset of samples within the
experiment that should be aligned. All samples not being part of the subset
will be aligned based on the adjustment of the closest sample within the
subset. This allows to e.g. exclude blank samples from the alignment process
with their retention times being still adjusted based on the alignment
results of the \emph{real} samples.
}
\note{
The method ensures that returned adjusted retention times are
increasingly ordered, just as the raw retention times.
}
\references{
Colin A. Smith, Elizabeth J. Want, Grace O'Maille, Ruben Abagyan and
Gary Siuzdak. "XCMS: Processing Mass Spectrometry Data for Metabolite
Profiling Using Nonlinear Peak Alignment, Matching, and Identification"
\emph{Anal. Chem.} 2006, 78:779-787.
}
\author{
Colin Smith, Johannes Rainer
}
\concept{core retention time correction algorithms}
