% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/MsExperiment.R,
%   R/XcmsExperiment-plotting.R, R/XcmsExperiment.R, R/methods-XCMSnExp.R
\name{filterFeatureDefinitions}
\alias{filterFeatureDefinitions}
\alias{filterRt,MsExperiment-method}
\alias{filterMzRange,MsExperiment-method}
\alias{filterMz,MsExperiment-method}
\alias{filterMsLevel,MsExperiment-method}
\alias{uniqueMsLevels,MsExperiment-method}
\alias{filterFile,MsExperiment-method}
\alias{rtime,MsExperiment-method}
\alias{fromFile,MsExperiment-method}
\alias{fileNames,MsExperiment-method}
\alias{polarity,MsExperiment-method}
\alias{filterIsolationWindow,MsExperiment-method}
\alias{chromatogram,MsExperiment-method}
\alias{plot,MsExperiment,missing-method}
\alias{XcmsExperiment}
\alias{XcmsExperiment-class}
\alias{filterChromPeaks}
\alias{featureArea}
\alias{quantify}
\alias{c.XcmsExperiment}
\alias{[,XcmsExperiment,ANY,ANY,ANY-method}
\alias{filterIsolationWindow,XcmsExperiment-method}
\alias{filterRt,XcmsExperiment-method}
\alias{filterMzRange,XcmsExperiment-method}
\alias{filterMsLevel,XcmsExperiment-method}
\alias{hasChromPeaks,XcmsExperiment-method}
\alias{dropChromPeaks,XcmsExperiment-method}
\alias{chromPeaks<-,XcmsExperiment-method}
\alias{chromPeaks,XcmsExperiment-method}
\alias{chromPeakData<-,XcmsExperiment-method}
\alias{chromPeakData,XcmsExperiment-method}
\alias{filterChromPeaks,XcmsExperiment-method}
\alias{dropAdjustedRtime,XcmsExperiment-method}
\alias{hasAdjustedRtime,MsExperiment-method}
\alias{rtime,XcmsExperiment-method}
\alias{adjustedRtime,XcmsExperiment-method}
\alias{hasFeatures,XcmsExperiment-method}
\alias{featureArea,XcmsResult-method}
\alias{featureDefinitions<-,XcmsExperiment-method}
\alias{featureDefinitions,XcmsExperiment-method}
\alias{dropFeatureDefinitions,XcmsExperiment-method}
\alias{filterFeatureDefinitions,XcmsExperiment-method}
\alias{hasFilledChromPeaks,XcmsExperiment-method}
\alias{dropFilledChromPeaks,XcmsExperiment-method}
\alias{quantify,XcmsExperiment-method}
\alias{featureValues,XcmsExperiment-method}
\alias{chromatogram,XcmsExperiment-method}
\alias{processHistory,XcmsExperiment-method}
\alias{filterFile,XcmsExperiment-method}
\title{Next Generation \code{xcms} Result Object}
\usage{
filterFeatureDefinitions(object, ...)

\S4method{filterRt}{MsExperiment}(object, rt = numeric(), ...)

\S4method{filterMzRange}{MsExperiment}(object, mz = numeric(), msLevel. = uniqueMsLevels(object))

\S4method{filterMz}{MsExperiment}(object, mz = numeric(), msLevel. = uniqueMsLevels(object))

\S4method{filterMsLevel}{MsExperiment}(object, msLevel. = uniqueMsLevels(object))

\S4method{uniqueMsLevels}{MsExperiment}(object)

\S4method{filterFile}{MsExperiment}(object, file = integer(), ...)

\S4method{rtime}{MsExperiment}(object)

\S4method{fromFile}{MsExperiment}(object)

\S4method{fileNames}{MsExperiment}(object)

\S4method{polarity}{MsExperiment}(object)

\S4method{filterIsolationWindow}{MsExperiment}(object, mz = numeric())

\S4method{chromatogram}{MsExperiment}(
  object,
  rt = matrix(nrow = 0, ncol = 2),
  mz = matrix(nrow = 0, ncol = 2),
  aggregationFun = "sum",
  msLevel = 1L,
  isolationWindowTargetMz = NULL,
  chunkSize = 2L,
  return.type = "MChromatograms",
  BPPARAM = bpparam()
)

\S4method{plot}{MsExperiment,missing}(x, y, msLevel = 1L, peakCol = "#ff000060", ...)

\method{c}{XcmsExperiment}(...)

\S4method{[}{XcmsExperiment,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{filterIsolationWindow}{XcmsExperiment}(object, mz = numeric())

\S4method{filterRt}{XcmsExperiment}(object, rt, msLevel.)

\S4method{filterMzRange}{XcmsExperiment}(object, mz = numeric(), msLevel. = uniqueMsLevels(object))

\S4method{filterMsLevel}{XcmsExperiment}(object, msLevel. = uniqueMsLevels(object))

\S4method{hasChromPeaks}{XcmsExperiment}(object, msLevel = integer())

\S4method{dropChromPeaks}{XcmsExperiment}(object, keepAdjustedRtime = FALSE)

\S4method{chromPeaks}{XcmsExperiment}(object) <- value

\S4method{chromPeaks}{XcmsExperiment}(
  object,
  rt = numeric(),
  mz = numeric(),
  ppm = 0,
  msLevel = integer(),
  type = c("any", "within", "apex_within"),
  isFilledColumn = FALSE,
  columns = character()
)

\S4method{chromPeakData}{XcmsExperiment}(object) <- value

\S4method{chromPeakData}{XcmsExperiment}(
  object,
  msLevel = integer(),
  columns = character(),
  return.type = c("DataFrame", "data.frame")
)

\S4method{filterChromPeaks}{XcmsExperiment}(
  object,
  keep = rep(TRUE, nrow(.chromPeaks(object))),
  method = "keep",
  ...
)

\S4method{dropAdjustedRtime}{XcmsExperiment}(object)

\S4method{hasAdjustedRtime}{MsExperiment}(object)

\S4method{rtime}{XcmsExperiment}(object, adjusted = hasAdjustedRtime(object))

\S4method{adjustedRtime}{XcmsExperiment}(object)

\S4method{hasFeatures}{XcmsExperiment}(object, msLevel = integer())

\S4method{featureArea}{XcmsResult}(
  object,
  mzmin = min,
  mzmax = max,
  rtmin = min,
  rtmax = max,
  features = character(),
  minMzWidthPpm = 0
)

\S4method{featureDefinitions}{XcmsExperiment}(object) <- value

\S4method{featureDefinitions}{XcmsExperiment}(
  object,
  mz = numeric(),
  rt = numeric(),
  ppm = 0,
  type = c("any", "within", "apex_within"),
  msLevel = integer()
)

\S4method{dropFeatureDefinitions}{XcmsExperiment}(object, keepAdjustedRtime = FALSE)

\S4method{filterFeatureDefinitions}{XcmsExperiment}(object, features = integer())

\S4method{hasFilledChromPeaks}{XcmsExperiment}(object)

\S4method{dropFilledChromPeaks}{XcmsExperiment}(object)

\S4method{quantify}{XcmsExperiment}(object, ...)

\S4method{featureValues}{XcmsExperiment}(
  object,
  method = c("medret", "maxint", "sum"),
  value = "into",
  intensity = "into",
  filled = TRUE,
  missing = NA_real_,
  msLevel = integer()
)

\S4method{chromatogram}{XcmsExperiment}(
  object,
  rt = matrix(nrow = 0, ncol = 2),
  mz = matrix(nrow = 0, ncol = 2),
  aggregationFun = "sum",
  msLevel = 1L,
  chunkSize = 2L,
  isolationWindowTargetMz = NULL,
  return.type = c("XChromatograms", "MChromatograms"),
  include = character(),
  chromPeaks = c("apex_within", "any", "none"),
  BPPARAM = bpparam()
)

\S4method{processHistory}{XcmsExperiment}(object, type)

\S4method{filterFile}{XcmsExperiment}(
  object,
  file,
  keepAdjustedRtime = hasAdjustedRtime(object),
  keepFeatures = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{XcmsExperiment} object.}

\item{...}{Additional optional parameters. For \code{quantify()}: any parameter
for the \code{featureValues} call used to extract the feature value matrix.}

\item{rt}{For \code{chromPeaks()} and \code{featureDefinitions()}: \code{numeric(2)}
defining the retention time range for which chromatographic peaks
or features should be returned. The full range is used by default.
For \code{chromatogram()}: two column numerical \code{matrix} with each row
representing the lower and upper retention time window(s) for the
chromatograms. If not provided the full retention time range is used.}

\item{mz}{For \code{chromPeaks()} and \code{featureDefinitions()}: \code{numeric(2)}
optionally defining the m/z range for which chromatographic peaks
or feature definitions should be returned. The full m/z range is
used by default.
For \code{chromatogram()}: two-column numerical \code{matrix} with each row
representing m/z range that should be aggregated into a chromatogram.
If not provided the full m/z range of the data will be used (and hence
a total ion chromatogram will be returned if \code{aggregationFun = "sum"}
is used).
For \code{filterIsolationWindow()}: \code{numeric(1)} defining the m/z
that should be contained within the spectra's isolation window.}

\item{msLevel.}{For \code{filterRt()}: ignored. \code{filterRt()} will always filter
by retention times on all MS levels regardless of this parameter.
For \code{chromatogram()}: \code{integer} with the MS level from which the
chromatogram(s) should be extracted. Has to be either of length 1 or
length equal to the numer of rows of the parameters \code{mz} and \code{rt}
defining the m/z and rt regions from which the chromatograms should
be created. Defaults to \code{msLevel = 1L}.
for \code{filterMsLevel()}: \code{integer} defining the MS level(s) to which the
data should be subset.}

\item{file}{For \code{filterFile()}: \code{integer} with the indices of the samples
(files) to which the data should be subsetted.}

\item{aggregationFun}{For \code{chromatogram()}: \code{character(1)} defining the
function that should be used to \emph{aggregate} intensities for retention
time (i.e. each spectrum) along the specified m/z range (parameter
\code{mz}). Defaults to \code{aggregationFun = "sum"} and hence all intensities
will be summed up. Alternatively, use \code{aggregationFun = "max"} to use
the maximal intensity per m/z range to create a base peak
chromatogram (BPC).}

\item{msLevel}{\code{integer} defining the MS level (or multiple MS level if the
function supports it).}

\item{isolationWindowTargetMz}{For \code{chromatogram()}: \code{numeric} (of length
equal to the number of rows of \code{rt} and \code{mz}) with the isolation window
target m/z of the MS2 spectra from which the chromatgrom should be
generated. For MS1 data (\code{msLevel = 1L}, the default), this parameter
is ignored. See examples on \code{chromatogram()} below for further
information.}

\item{chunkSize}{For \code{chromatogram()}: \code{integer(1)} defining the number of
files from which the data should be loaded at a time into memory.
Defaults to \code{chunkSize = 2L}.}

\item{return.type}{For \code{chromPeakData()}: \code{character(1)} defining the
class of the returned object. Can be either \code{"DataFrame"} (the default)
or \code{"data.frame"}. For \code{chromatogram()}: \code{character(1)} defining the
type of the returned object. Currently only
\code{return.type = "MChromatograms"} is supported.}

\item{BPPARAM}{For \code{chromatogram()}: parallel processing setup. Defaults
to \code{BPPARAM = bpparam()}. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for more
information.}

\item{x}{An \code{XcmsExperiment} object.}

\item{y}{For \code{plot()}: should not be defined as it is not supported.}

\item{peakCol}{For \code{plot()}: defines the border color of the rectangles
indicating the identified chromatographic peaks. Only a single color
is supported. Defaults to `peakCol = "#ff000060".}

\item{i}{For \code{[}: \code{integer} or \code{logical} defining the samples/files to
subset.}

\item{j}{For \code{[}: not supported.}

\item{drop}{For \code{[}: ignored.}

\item{keepAdjustedRtime}{\code{logical(1)}: whether adjusted retention times (if
present) should be retained.}

\item{value}{For \code{featureValues()}: \code{character(1)} defining which value
should be reported for each feature in each sample. Can be any column
of the \code{chromPeaks()} matrix or \code{"index"} if simply the index of
the assigned peak should be returned. Defaults to \code{value = "into"}
thus the integrated peak area is reported.}

\item{ppm}{For \code{chromPeaks()} and \code{featureDefinitions()}: optional
\code{numeric(1)} specifying the ppm by which the m/z range (defined by
\code{mz} should be extended. For a value of \code{ppm = 10}, all peaks
within \code{mz[1] - ppm / 1e6} and \code{mz[2] + ppm / 1e6} are returned.}

\item{type}{For \code{chromPeaks()} and \code{featureDefinitions()} and only if either
\code{mz} and \code{rt} are defined too: \code{character(1)}: defining which peaks
(or features) should be returned. For \code{type = "any"}: returns all
chromatographic peaks or features also only partially overlapping any of
the provided ranges. For \code{type = "within"}: returns only peaks or
features completely within the region defined by \code{mz} and/or \code{rt}.
For \code{type = "apex_within"}: returns peaks or features for which the m/z
and retention time of the peak's apex is within the region defined by
\code{mz} and/or \code{rt}.
For \code{processHistory()}: restrict returned processing steps to specific
types. Use \code{\link[=processHistoryTypes]{processHistoryTypes()}} to list all supported values.}

\item{isFilledColumn}{For \code{chromPeaks()}: \code{logical(1)} whether a column
\code{"is_filled"} should be included in the returned \code{matrix} with the
information whether a peak was detected or \emph{only} filled-in. Note that
this information is also provided in the \code{chromPeakData} data frame.}

\item{columns}{For \code{chromPeaks()} and \code{chromPeakData()}: optional
\code{character} to specify the names of the columns that should be
returned. By default (with \code{columns = character()} all columns are
returned.}

\item{keep}{For \code{filterChromPeaks()}: \code{logical}, \code{integer} or \code{character}
specifying which chromatographic peaks to keep. If \code{logical} the
length of \code{keep} needs to match the number of rows of \code{chromPeaks()}.
Alternatively, \code{keep} allows to specify the \code{index} (row) of peaks
to keep or their ID (i.e. row name in \code{chromPeaks()}).}

\item{method}{For \code{featureValues()}: \code{character(1)} specifying the method to
resolve multi-peak mappings within the same sample (correspondence
analysis can assign more than one chromatographic peak within a sample
to the same feature, e.g. if they are close in retention time). Options:
\code{method = "medret"}: report the value for the chromatographic peak
closest to the feature's median retention time.
\code{method = "maxint"}: report the value for the chromatographic peak
with the largest signal (parameter \code{intensity} allows to select the
column in \code{chromPeaks} that should be used for \emph{signal}).
\code{method = "sum"}: sum the value for all chromatographic peaks in a
sample assigned to the same feature. The default is \code{method = "medret"}.
For \code{filterChromPeaks()}: currently only \code{method = "keep"} is supported.}

\item{adjusted}{For \verb{rtime,XcmsExperiment}: whether adjusted or \emph{raw}
retention times should be returned. The default is to return adjusted
retention times, if available.}

\item{mzmin}{For \code{featureArea()}: function to calculate the \code{"mzmin"} of
a feature based on the \code{"mzmin"} values of the individual
chromatographic peaks assigned to that feature. Defaults to
\code{mzmin = min}.}

\item{mzmax}{For \code{featureArea()}: function to calculate the \code{"mzmax"} of
a feature based on the \code{"mzmax"} values of the individual
chromatographic peaks assigned to that feature. Defaults to
\code{mzmax = max}.}

\item{rtmin}{For \code{featureArea()}: function to calculate the \code{"rtmin"} of
a feature based on the \code{"rtmin"} values of the individual
chromatographic peaks assigned to that feature. Defaults to
\code{rtmin = min}.}

\item{rtmax}{For \code{featureArea()}: function to calculate the \code{"rtmax"} of
a feature based on the \code{"rtmax"} values of the individual
chromatographic peaks assigned to that feature. Defaults to
\code{rtmax = max}.}

\item{features}{For \code{filterFeatureDefinitions()} and \code{featureArea()}:
\code{logical}, \code{integer} or \code{character} defining the features to keep or
from which to extract the feature area, respectively. See function
description for more information.}

\item{minMzWidthPpm}{For \code{featureArea()}: \code{numeric(1)} defining the minimal
guaranteed m/z width (expressed in ppm of the feature's m/z) of the
reported feature areas. Defaults to \code{minMzWidthPpm = 0.0}. See
documentation of the \code{featureArea()} for more information.}

\item{intensity}{For \code{featureValues()}: \code{character(1)} specifying the name
of the column in the \code{chromPeaks(objects)} matrix containing the
intensity value of the peak that should be used for the conflict
resolution if \code{method = "maxint"}.}

\item{filled}{For \code{featureValues()}: \code{logical(1)} specifying whether values
for filled-in peaks should be reported. For \code{filled = TRUE} (the
default) filled peak values are returned, otherwise \code{NA} is reported
for the respective features in the samples in which no peak was
detected.}

\item{missing}{For \code{featureValues()}: default value for missing values.
Allows to define the value that should be reported for a missing peak
intensity. Defaults to \code{missing = NA_real_}.}

\item{include}{For \code{chromatogram()}: deprecated; use parameter \code{chromPeaks}
instead.}

\item{chromPeaks}{For \code{chromatogram()}: \code{character(1)} defining which
chromatographic peaks should be returned. Can be either
\code{chromPeaks = "apex_within"} (default) to return all chromatographic
peaks with the m/z and RT of their apex within the m/z and retention
time window, \code{chromPeaks = "any"} for all chromatographic peaks that
are overlapping with the m/z - retention time window or
\code{chromPeaks = "none"} to not include any chromatographic peaks. See
also parameter \code{type} below for additional information.}

\item{keepFeatures}{for most subsetting functions (\code{[}, \code{filterFile()}):
\code{logical(1)}: wheter eventually present feature definitions should
be retained in the returned (filtered) object.}
}
\description{
The \code{XcmsExperiment} is a data container for \emph{xcms} preprocessing
results (i.e. results from chromatographic peak detection, alignment and
correspondence analysis). It is the preferred and default result object
since version 4 of \emph{xcms}.

It provides the same functionality than the \link{XCMSnExp} object, but uses the
more advanced and modern MS infrastructure provided by the \emph{MsExperiment}
and \emph{Spectra} Bioconductor packages. This enables a much higher flexibility
of data representation and storage and ensures future expandability.

Documentation of the various functions for \code{XcmsExperiment} objects are
grouped by topic and provided in the sections below.

The default \emph{xcms} data analysis workflow is to perform:
\itemize{
\item chromatographic peak detection using \code{\link[=findChromPeaks]{findChromPeaks()}}
\item optionally \emph{refine} identified chromatographic peaks using
\code{\link[=refineChromPeaks]{refineChromPeaks()}} (this is highly suggested for \emph{centWave}-based
chromatographic peak detection)
\item retention time alignment (retention time adjustment) using \code{\link[=adjustRtime]{adjustRtime()}}.
Depending on the method used, this may require to run a correspondence
analysis first
\item correspondence analysis to group chromatographic peaks across samples
to define the LC-MS features using the \code{\link[=groupChromPeaks]{groupChromPeaks()}} function
\item gap-filling to \emph{rescue} signal in samples in which no chromatographic
peak was identified and hence a missing value would be reported. This
can be performed using the \code{\link[=fillChromPeaks]{fillChromPeaks()}} function.
}

For very large LC-MS experiments (either with a very large number of samples
or very large data files, or both), the \code{\link[=XcmsExperimentHdf5]{XcmsExperimentHdf5()}} object can
be used instead. See the respective help page for more information.
}
\section{Subset, filter and combine}{

\itemize{
\item \code{[}: subset an \code{XcmsExperiment} by \strong{sample} (parameter \code{i}). Subsetting
will by default drop correspondence results (as subsetting by samples will
obviously affect the feature definition) while alignment results (adjusted
retention times) and identified chromatographic peaks (for the selected
samples) will be retained. Which preprocessing results should be
kept or dropped can also be configured with optional parameters
\code{keepChromPeaks} (by default \code{TRUE}), \code{keepAdjustedRtime} (by default
\code{TRUE}) and \code{keepFeatures} (by default \code{FALSE}).
\item \code{c()}: multiple \code{XcmsExperiment} objects can be combined into one using the
\code{c()} function. This requires however that all the \code{XcmsExperiments}'
\code{Spectra} objects use the same type of \code{MsBackend} and that their
processing queues are empty. Also, only combining of peak detection
results is supported. Any eventually present alignment or correspondence
results will be dropped before combining the \code{XcmsExperiment} objects.
Finally, at present, only the MS data of the individual \code{XcmsExperiment}
objects is combined and any data eventually present in the \verb{@qdata},
\verb{@otherData} and \verb{@experimentFiles} slots is ignored.
The function returns a \code{XcmsExperiment} objects with the combined MS data
(\code{Spectra} objects) and chromatographic peak detection results.
\item \code{filterChromPeaks()}: filter chromatographic peaks of an \code{XcmsExperiment}
keeping only those specified with parameter \code{keep}. Returns the
\code{XcmsExperiment} with the filtered data. Chromatographic peaks to
retain can be specified either by providing their index in the
\code{chromPeaks()} matrix, their ID (rowname in \code{chromPeaks()}) or with a
\code{logical} vector with the same length than number of rows of
\code{chromPeaks()}. Assignment of chromatographic peaks are updated to
eventually present feature definitions after filtering.
\item \code{filterFeatureDefinitions()}: filter feature definitions of an
\code{XcmsExperiment} keeping only those defined with parameter \code{features},
which can be a \code{logical} of length equal to the number of features,
an \code{integer} with the index of the features in
\code{featureDefinitions(object)} to keep or a \code{character} with the feature
IDs (i.e. row names in \code{featureDefinitions(object)}).
\item \code{filterFile()}: filter an \code{XcmsExperiment} (or \code{MsExperiment}) by \emph{file}
(sample). The index of the samples to which the data should be subsetted
can be specified with parameter \code{file}. The sole purpose of this function
is to provide backward compatibility with the \code{MSnbase} package. Wherever
possible, the \code{[} function should be used instead for any sample-based
subsetting. Parameters \code{keepChromPeaks}, \code{keepAdjustedRtime} and
\code{keepChromPeaks} can be passed using \code{...}.
Note also that in contrast to \code{[}, \code{filterFile()} does not support
subsetting in arbitrary order.
\item \code{filterIsolationWindow()}: filter the \strong{spectra} within an \code{MsExperiment}
or \code{XcmsExperiment} object keeping only those with an isolation window
containing the specified m/z (i.e., keeping spectra with an
\code{"isolationWindowLowerMz"} smaller than the user-provided \code{mz} and an
\code{"isolationWindowUpperMz"} larger than \code{mz}). For an \code{XcmsExperiment} also
all chromatographic peaks (and subsequently also features) are removed for
which the range of their \code{"isolationWindowLowerMz"} and
\code{"isolationWindowUpperMz"} (columns in \code{chromPeakData()}) do not contain
the user provided \code{mz}.
\item \code{filterMsLevel()}: filter the data of the \code{XcmsExperiment} or
\code{MsExperiment} to keep only data of the MS level(s) specified with
parameter \code{msLevel.}.
\item \code{filterMz()}, \code{filterMzRange()}: filter the spectra within an
\code{XcmsExperiment} or \code{MsExperiment} to the specified m/z range (parameter
\code{mz}). For \code{XcmsExperiment} also identified chromatographic peaks and
features are filtered keeping only those that are within the specified
m/z range (i.e. for which the m/z of the peak apex is within the m/z
range). Parameter \code{msLevels.} allows to restrict the filtering to
only specified MS levels. By default data from all MS levels are
filtered.
\item \code{filterRt()}: filter an \code{XcmsExperiment} keeping only data within the
specified retention time range (parameter \code{rt}). This function will keep
all preprocessing results present within the retention time range: all
identified chromatographic peaks with the retention time of the apex
position within the retention time range \code{rt} are retained along, if
present, with the associated features.
Parameter \code{msLevel.} is currently ignored, i.e. filtering will always
performed on \strong{all} MS levels of the object.
}
}

\section{Functionality related to chromatographic peaks}{

\itemize{
\item \code{chromatogram()}: extract chromatographic data from a data set. Parameters
\code{mz} and \code{rt} allow to define specific m/z - retention time regions to
extract the data from (to e.g. for extracted ion chromatograms EICs).
Both parameters are expected to be numerical two-column matrices with
the first column defining the lower and the second the upper margin.
Each row can define a separate m/z - retention time region. Currently
the function returns a \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} object for \code{object}
being a \code{MsExperiment} or, for \code{object} being an \code{XcmsExperiment},
either a \code{MChromatograms} or \code{\link[=XChromatograms]{XChromatograms()}} depending on parameter
\code{return.type} (can be either \code{"MChromatograms"} or \code{"XChromatograms"}).
For the latter also chromatographic peaks detected within the provided
m/z and retention times are returned. Parameter \code{chromPeaks} allows
to specify which chromatographic peaks should be reported. See
documentation on the \code{chromPeaks} parameter for more information.
If the \code{XcmsExperiment} contains correspondence results, also the
associated feature definitions will be included in the returned
\code{XChromatograms}. By default the function returns chromatograms from MS1
data, but by setting parameter \code{msLevel = 2L} it is possible to e.g.
extract also MS2 chromatograms. By default, with parameter
\code{isolationWindowTargetMz = NULL} or \code{isolationWindowTargetMz = NA_real_},
data from \strong{all} MS2 spectra will be considered in the chromatogram
extraction. If MS2 data was generated within different m/z isolation
windows (such as e.g. with Scies SWATH data), the parameter
\code{isolationWindowTargetMz} should be used to ensure signal is only extracted
from the respective isolation window. The \code{isolationWindowTargetMz()}
function on the \code{Spectra} object can be used to inspect/list available
isolation windows of a data set. See also the xcms \emph{LC-MS/MS vignette} for
examples and details.
\item \code{chromPeaks()}: returns a \code{numeric} matrix with the identified
chromatographic peaks. Each row represents a chromatographic peak
identified in one sample (file). The number of columns depends on the
peak detection algorithm (see \code{\link[=findChromPeaks]{findChromPeaks()}}) but most methods return
the following columns: \code{"mz"} (intensity-weighted mean of the m/z values
of all mass peaks included in the chromatographic peak), \code{"mzmin"} (
smallest m/z value of any mass peak in the chromatographic peak), \code{"mzmax"}
(largest m/z value of any mass peak in the chromatographic peak), \code{"rt"}
(retention time of the peak apex), \code{"rtmin"} (retention time of the first
scan/mass peak of the chromatographic peak), \code{"rtmax"} (retention time of
the last scan/mass peak of the chromatographic peak), \code{"into"} (integrated
intensity of the chromatographic peak), \code{"maxo"} (maximal intensity of any
mass peak of the chromatographic peak), \code{"sample"} (index of the sample
in \code{object} in which the peak was identified). Parameters \code{rt}, \code{mz},
\code{ppm}, \code{msLevel} and \code{type} allow to extract subsets of identified
chromatographic peaks from the \code{object}. Parameter \code{columns} allows to
optionally define which columns to extract. See parameter description
below for details.
\item \code{chromPeakData()}: returns a \code{DataFrame} with potential additional
\emph{annotations} for the identified chromatographic peaks. Each row in this
\code{DataFrame} corresponds to a row (same index and row name) in the
\code{chromPeaks()} matrix. The default \emph{annotations} are \code{"ms_level"} (the MS
level in which the peak was identified) and \code{"is_filled"} (whether the
chromatographic peak was \emph{detected} (by \code{\link[=findChromPeaks]{findChromPeaks()}}) or
\emph{filled-in} (by \code{\link[=fillChromPeaks]{fillChromPeaks()}}). Parameter \code{columns} can be used to
restrict the returned data frame to selected columns. Parameter
\code{return.type} can be used to specify the type of returned objects, either
a \code{DataFrame} (the default, \code{return.type = "DataFrame"}) or a \code{data.frame}
(\verb{return.type = "data.frame")}.
\item \code{chromPeakSpectra()}: extract MS spectra for identified chromatographic
peaks. This can be either all (full scan) MS1 spectra with retention
times between the retention time range of a chromatographic peak, all
MS2 spectra (if present) with a retention time within the retention
time range of a (MS1) chromatographic peak and a precursor m/z within
the m/z range of the chromatographic peak or single, selected spectra
depending on their total signal or highest signal. Parameter \code{msLevel}
allows to define from which MS level spectra should be extracted,
parameter \code{method} allows to define if all or selected spectra should
be returned. See \code{\link[=chromPeakSpectra]{chromPeakSpectra()}} for details.
\item \code{dropChromPeaks()}: removes (all) chromatographic peak detection results
from \code{object}. This will also remove any correspondence results (i.e.
features) and eventually present adjusted retention times from the object
if the alignment was performed \strong{after} the peak detection.
Alignment results (adjusted retention times) can be retained if parameter
\code{keepAdjustedRtime} is set to \code{TRUE}.
\item \code{dropFilledChromPeaks()}: removes chromatographic peaks added by gap
filling with \code{\link[=fillChromPeaks]{fillChromPeaks()}}.
\item \code{fillChromPeaks()}: perform \emph{gap filling} to integrate signal missing
values in samples in which no chromatographic peak was found. This
depends on correspondence results, hence \code{groupChromPeaks()} needs to be
called first. For details and options see \code{\link[=fillChromPeaks]{fillChromPeaks()}}.
\item \code{findChromPeaks}: perform chromatographic peak detection. See
\code{\link[=findChromPeaks]{findChromPeaks()}} for details.
\item \code{hasChromPeaks()}: whether the object contains peak detection results.
Parameter \code{msLevel} allows to check whether peak detection results are
available for the specified MS level(s).
\item \code{hasFilledChromPeaks()}: whether gap-filling results (i.e., filled-in
chromatographic peaks) are present.
\item \code{manualChromPeaks()}: \emph{manually} add chromatographic peaks by defining
their m/z and retention time ranges. See \code{\link[=manualChromPeaks]{manualChromPeaks()}} for
details and examples.
\item \code{plotChromPeakImage()}: show the \emph{density} of identified chromatographic
peaks per file along the retention time. See \code{\link[=plotChromPeakImage]{plotChromPeakImage()}} for
details.
\item \code{plotChromPeaks()}: indicate identified chromatographic peaks from one
sample in the RT-m/z space. See \code{\link[=plotChromPeaks]{plotChromPeaks()}} for details.
\item \code{plotPrecursorIons()}: general visualization of precursor ions of
LC-MS/MS data. See \code{\link[=plotPrecursorIons]{plotPrecursorIons()}} for details.
\item \code{refineChromPeaks()}: \emph{refines} identified chromatographic peaks in
\code{object}. See \code{\link[=refineChromPeaks]{refineChromPeaks()}} for details.
}
}

\section{Functionality related to alignment}{

\itemize{
\item \code{adjustedRtime()}: extract adjusted retention times. This is just an
alias for \code{rtime(object, adjusted = TRUE)}.
\item \code{adjustRtime()}: performs retention time adjustment (alignment) of the
data. See \code{\link[=adjustRtime]{adjustRtime()}} for details.
\item \code{applyAdjustedRtime()}: replaces the original (raw) retention times with
the adjusted ones. See \code{\link[=applyAdjustedRtime]{applyAdjustedRtime()}} for more information.
\item \code{dropAdjustedRtime()}: drops alignment results (adjusted retention time)
from the result object. This also reverts the retention times of
identified chromatographic peaks if present in the result object. Note
that any results from a correspondence analysis (i.e. feature definitions)
will be dropped too (if the correspondence analysis was performed
\strong{after} the alignment). This can be overruled with
\code{keepAdjustedRtime = TRUE}.
\item \code{hasAdjustedRtime()}: whether alignment was performed on the object (i.e.,
the object contains alignment results).
\item \code{plotAdjustedRtime()}: plot the alignment results; see
\code{\link[=plotAdjustedRtime]{plotAdjustedRtime()}} for more information.
}
}

\section{Functionality related to correspondence analysis}{

\itemize{
\item \code{dropFeatureDefinitions()}: removes any correspondence analysis results
from \code{object} as well as any filled-in chromatographic peaks. By default
(with parameter \code{keepAdjustedRtime = FALSE}) also all alignment results
will be removed if alignment was performed \strong{after} the correspondence
analysis. This can be overruled with \code{keepAdjustedRtime = TRUE}.
\item \code{featureArea()}: returns a \code{matrix} with columns \code{"mzmin"}, \code{"mzmax"},
\code{"rtmin"} and \code{"rtmax"} with the m/z and retention time range for each
feature (row) in \code{object}. By default these represent the minimal m/z
and retention times as well as maximal m/z and retention times for
all chromatographic peaks assigned to that feature. Parameter
\code{minMzWidthPpm} (default \verb{minMzWidthPpm = 0.01) can be used to define a minimal required (total) m/z width expressed in ppm of the features' m/z. With a }minMzWidthPpm\verb{larger than 0 the reported}"mzmin"\verb{is the minimum of the determined minimal m/z for a feature (based on parameter}mzmin\verb{) and the m/z of the feature minus }minMzWidthPpm / 2\verb{ppm of the feature's m/z value. The reported}"mzmax"\verb{is calculated in the same way. Parameter}features\verb{allows to extract these values for selected features only. Parameters}mzmin\verb{, }mzmax\verb{, }rtmin\code{and}rtmax\verb{allow to define the function to calculate the reported}"mzmin"\verb{, }"mzmax"\verb{, }"rtmin"\code{and}"rtmax"` values.
\item \code{featureChromatograms()}: extract ion chromatograms (EICs) for each
feature in \code{object}. See \code{\link[=featureChromatograms]{featureChromatograms()}} for more details.
\item \code{featureDefinitions()}: returns a \code{data.frame} with feature definitions or
an empty \code{data.frame} if no correspondence analysis results are present.
Parameters \code{msLevel}, \code{mz}, \code{ppm} and \code{rt} allow to define subsets of
feature definitions that should be returned with the parameter \code{type}
defining how these parameters should be used to subset the returned
\code{data.frame}. See parameter descriptions for details.
\item \code{featureSpectra()}: returns a \code{\link[Spectra:Spectra]{Spectra::Spectra()}} or \code{List} of \code{Spectra}
with (MS1 or MS2) spectra associated to each feature's chromatographic
peaks. See \code{\link[=featureSpectra]{featureSpectra()}} for more details and available parameters.
\item \code{featuresSummary()}: calculate a simple summary on features. See
\code{\link[=featureSummary]{featureSummary()}} for details.
\item \code{groupChromPeaks()}: performs the correspondence analysis (i.e., grouping
of chromatographic peaks into LC-MS \emph{features}). See \code{\link[=groupChromPeaks]{groupChromPeaks()}}
for details.
\item \code{hasFeatures()}: whether correspondence analysis results are presentin in
\code{object}. The optional parameter \code{msLevel} allows to define the  MS
level(s) for which it should be determined if feature definitions are
available.
\item \code{overlappingFeatures()}: identify features that overlapping or close in
m/z - rt dimension. See \code{\link[=overlappingFeatures]{overlappingFeatures()}} for more information.
}
}

\section{Extracting data and results from an \code{XcmsExperiment}}{


Preprocessing results can be extracted using the following functions:
\itemize{
\item \code{chromPeaks()}: extract identified chromatographic peaks. See section on
chromatographic peak detection for details.
\item \code{featureDefinitions()}: extract the definition of \emph{features}
(chromatographic peaks grouped across samples). See section on
correspondence analysis for details.
\item \code{featureValues()}: extract a \code{matrix} of \emph{values} for features from each
sample (file). Rows are features, columns samples. Which \emph{value} should be
returned can be defined with parameter \code{value}, which can be any column of
the \code{chromPeaks()} matrix. By default (\code{value = "into"}) the integrated
chromatographic peak intensities are returned. With parameter \code{msLevel} it
is possible to extract values for features from certain MS levels.
During correspondence analysis, more than one chromatographic peak per
sample can be assigned to the same feature (e.g. if they are very close in
retention time). Parameter \code{method} allows to define the strategy to deal
with such cases: \code{method = "medret"}: report the value from the
chromatographic peak with the apex position closest to the feautre's
median retention time. \code{method = "maxint"}: report the value from the
chromatographic peak with the largest signal (parameter \code{intensity} allows
to define the column in \code{chromPeaks} that should be selected; defaults to
\verb{intensity = "into"). }method = "sum"`: sum the values for all
chromatographic peaks assigned to the feature in the same sample.
\item \code{quantify()}: extract the correspondence analysis results as a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment()}}. The feature \emph{values}
are used as \code{assay} in the returned \code{SummarizedExperiment}, \code{rowData}
contains the \code{featureDefinitions} (without column \code{"peakidx"}) and
\code{colData} the \code{sampleData} of \code{object}. Additional parameters to the
\code{featureValues} function (that is used to extract the feature value
matrix) can be passed \emph{via} \code{...}.
}
}

\section{Visualization}{

\itemize{
\item \code{plot()}: plot for each file the position of individual peaks in the m/z -
retention time space (with color-coded intensity) and a base peak
chromatogram. This function should ideally be called only on a data subset
(i.e. after using \code{filterRt()} and \code{filterMz()} to restrict to a region of
interest). Parameter \code{msLevel} allows to define from which MS level the
plot should be created. If \code{x} is a \code{XcmsExperiment} with available
identified chromatographic peaks, also the region defining the peaks
are indicated with a rectangle. Parameter \code{peakCol} allows to define the
color of the border for these rectangles.
\item \code{plotAdjustedRtime()}: plot the alignment results; see
\code{\link[=plotAdjustedRtime]{plotAdjustedRtime()}} for more information.
\item \code{plotChromPeakImage()}: show the \emph{density} of identified chromatographic
peaks per file along the retention time. See \code{\link[=plotChromPeakImage]{plotChromPeakImage()}} for
details.
\item \code{plotChromPeaks()}: indicate identified chromatographic peaks from one
sample in the RT-m/z space. See \code{\link[=plotChromPeaks]{plotChromPeaks()}} for details.
}
}

\section{General functionality and functions for backward compatibility}{

\itemize{
\item \code{uniqueMsLevels()}: returns the unique MS levels of the spectra in
\code{object}.
}

The functions listed below ensure compatibility with the \emph{older}
\code{\link[=XCMSnExp]{XCMSnExp()}} xcms result object. Also, an \code{XcmsExperiment} can be coerced
to the \emph{older} \code{XCMSnExp} class using \code{as(object, "XCMSnExp")} same as a
\code{XCMSnExp} class can be coerced to \code{XcmsExperiment} using
\code{as(object, "XcmsExperiment")}.
\itemize{
\item \code{fileNames()}: returns the original data file names for the spectra data.
Ideally, the \code{dataOrigin} or \code{dataStorage} spectra variables from the
object's \code{spectra()} should be used instead.
\item \code{fromFile()}: returns the file (sample) index for each spectrum within
\code{object}. Generally, subsetting by sample using the \code{[} is the preferred
way to get spectra from a specific sample.
\item \code{polarity()}: returns the polarity information for each spectrum in
\code{object}.
\item \code{processHistory()}: returns a \code{list} with \link{ProcessHistory}
\emph{process history} objects that contain also the parameter object used
for the different processings. Optional parameter \code{type} allows to
query for specific processing steps.
\item \code{rtime()}: extract retention times of the \strong{spectra} from the
\code{MsExperiment} or \code{XcmsExperiment} object. It is thus a shortcut for
\code{rtime(spectra(object))} which would be the preferred way to extract
retention times from an \code{MsExperiment}. The \code{rtime()} method for
\code{XcmsExperiment} has an additional parameter \code{adjusted} which allows to
define whether adjusted retention times (if present - \code{adjusted = TRUE})
or \emph{raw} retention times (\code{adjusted = FALSE}) should be returned. By
default adjusted retention times are returned if available.
}
}

\section{Differences compared to the \code{\link[=XCMSnExp]{XCMSnExp()}} object}{

\itemize{
\item Subsetting by \code{[} supports arbitrary ordering.
}
}

\examples{

## Create a MsExperiment object representing the data from an LC-MS
## experiment.
library(MsExperiment)

## Define the raw data files
fls <- c(system.file('cdf/KO/ko15.CDF', package = "faahKO"),
         system.file('cdf/KO/ko16.CDF', package = "faahKO"),
         system.file('cdf/KO/ko18.CDF', package = "faahKO"))

## Define a data frame with the sample characterization
df <- data.frame(mzML_file = basename(fls),
                sample = c("ko15", "ko16", "ko18"))
## Importe the data. This will initialize a `Spectra` object representing
## the raw data and assign these to the individual samples.
mse <- readMsExperiment(spectraFiles = fls, sampleData = df)

## Extract a total ion chromatogram and base peak chromatogram
## from the data
bpc <- chromatogram(mse, aggregationFun = "max")
tic <- chromatogram(mse)

## Plot them
par(mfrow = c(2, 1))
plot(bpc, main = "BPC")
plot(tic, main = "TIC")

## Extracting MS2 chromatographic data
##
## To show how MS2 chromatograms can be extracted we first load a DIA
## (SWATH) data set.
mse_dia <- readMsExperiment(system.file("TripleTOF-SWATH",
    "PestMix1_SWATH.mzML", package = "msdata"))

## Extracting MS2 chromatogram requires also to specify the isolation
## window from which to extract the data. Without that chromatograms
## will be empty:
chr_ms2 <- chromatogram(mse_dia, msLevel = 2L)
intensity(chr_ms2[[1L]])

## First we list available isolation windows
table(isolationWindowTargetMz(spectra(mse_dia)))

## We can then extract the TIC of MS2 data for a specific isolation window
chr_ms2 <- chromatogram(mse_dia, msLevel = 2L,
    isolationWindowTargetMz = 244.05)
plot(chr_ms2)

####
## Chromatographic peak detection

## Perform peak detection on the data using the centWave algorith. Note
## that the parameters are chosen to reduce the run time of the example.
p <- CentWaveParam(noise = 10000, snthresh = 40, prefilter = c(3, 10000))
xmse <- findChromPeaks(mse, param = p)
xmse

## Have a quick look at the identified chromatographic peaks
head(chromPeaks(xmse))

## Extract chromatographic peaks identified between 3000 and 3300 seconds
chromPeaks(xmse, rt = c(3000, 3300), type = "within")

## Extract ion chromatograms (EIC) for the first two chromatographic
## peaks.
chrs <- chromatogram(xmse,
    mz = chromPeaks(xmse)[1:2, c("mzmin", "mzmax")],
    rt = chromPeaks(xmse)[1:2, c("rtmin", "rtmax")])

## An EIC for each sample and each of the two regions was extracted.
## Identified chromatographic peaks in the defined regions are extracted
## as well.
chrs

## Plot the EICs for the second defined region
plot(chrs[2, ])

## Subsetting the data to the results (and data) for the second sample
a <- xmse[2]
nrow(chromPeaks(xmse))
nrow(chromPeaks(a))

## Filtering the result by retention time: keeping all spectra and
## chromatographic peaks within 3000 and 3500 seconds.
xmse_sub <- filterRt(xmse, rt = c(3000, 3500))
xmse_sub
nrow(chromPeaks(xmse_sub))

## Perform an initial feature grouping to allow alignment using the
## peak groups method:
pdp <- PeakDensityParam(sampleGroups = rep(1, 3))
xmse <- groupChromPeaks(xmse, param = pdp)

## Perform alignment using the peak groups method.
pgp <- PeakGroupsParam(span = 0.4)
xmse <- adjustRtime(xmse, param = pgp)

## Visualizing the alignment results
plotAdjustedRtime(xmse)

## Performing the final correspondence analysis
xmse <- groupChromPeaks(xmse, param = pdp)

## Show the definition of the first 6 features
featureDefinitions(xmse) |> head()

## Extract the feature values; show the results for the first 6 rows.
featureValues(xmse) |> head()

## The full results can also be extracted as a `SummarizedExperiment`
## that would eventually simplify subsequent analyses with other packages.
## Any additional parameters passed to the function are passed to the
## `featureValues` function that is called to generate the feature value
## matrix.
se <- quantify(xmse, method = "sum")

## EICs for all features can be extracted with the `featureChromatograms`
## function. Note that, depending on the data set, extracting this for
## all features might take some time. Below we extract EICs for the
## first 10 features by providing the feature IDs.
chrs <- featureChromatograms(xmse,
    features = rownames(featureDefinitions(xmse))[1:10])
chrs

plot(chrs[3, ])
}
\author{
Johannes Rainer
}
