% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPPI_functions.R
\name{weighted_adj}
\alias{weighted_adj}
\title{Weighted adjacency matrix}
\usage{
weighted_adj(graph_op, GO_data, HPO_data)
}
\arguments{
\item{graph_op}{Igraph object based on OmniPath PPI interactions from
\code{\link{graph_from_op}}.}

\item{GO_data}{Data frame with GO annotations as provided by
\code{\link{wppi_go_data}}.}

\item{HPO_data}{Data frame with HPO annotations as provided by
\code{\link{wppi_hpo_data}}.}
}
\value{
Weighted adjacency matrix based on network topology and functional
    similarity between interacting proteins/genes based on ontology
    databases.
}
\description{
Converts adjacency to weighted adjacency using network topology
information (shared neighbors between connected nodes via
\code{\link{common_neighbors}}) integrated with genome and phenotype
factors from GO and HPO annotation terms (functionality computed by
\code{\link{functional_annot}}). At the end, the weighted adjacency
matrix is normalized by column.
}
\examples{
db <- wppi_data()
GO_data <- db$go
HPO_data <- db$hpo
# Genes of interest
genes_interest <-
    c("ERCC8", "AKT3", "NOL3", "GFI1B", "CDC25A", "TPX2", "SHE")
# Graph object with PPI 
graph_op <- graph_from_op(db$omnipath)
graph_op_1 <- subgraph_op(graph_op, genes_interest, 1)
# Filter ontology data
GO_data_filtered <- filter_annot_with_network(GO_data, graph_op_1)
HPO_data_filtered <- filter_annot_with_network(HPO_data, graph_op_1)
# Weighted adjacency
w_adj <- weighted_adj(graph_op_1, GO_data_filtered, HPO_data_filtered)

}
\seealso{
\itemize{
    \item{\code{\link{random_walk}}}
    \item{\code{\link{prioritization_genes}}}
    \item{\code{\link{common_neighbors}}}
    \item{\code{\link{graph_from_op}}}
    \item{\code{\link{subgraph_op}}}
    \item{\code{\link{score_candidate_genes_from_PPI}}}
    \item{\code{\link{wppi_go_data}}}
    \item{\code{\link{wppi_hpo_data}}}
}
}
