% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenienceWrappers.R
\name{plotTranscriptsFromUCSC}
\alias{plotTranscriptsFromUCSC}
\title{Plot transcripts directly from UCSC OrgDb and TxDb objects.}
\usage{
plotTranscriptsFromUCSC(orgdb, txdb, gene_names, transcript_ids = NULL, ...)
}
\arguments{
\item{orgdb}{UCSC OrgDb object.}

\item{txdb}{UCSC TxDb obejct.}

\item{gene_names}{List of gene genaes to be plot.}

\item{transcript_ids}{Optional list of transcript ids to be plot. (default = NULL)}

\item{...}{Additional parameters to be passed to plotTranscripts}
}
\value{
Transcript plot.
}
\description{
A wrapper around the plotTranscripts function. See the documentation for (\code{\link[wiggleplotr]{plotTranscripts}}) 
for more information. Note that this function is much slower than (\code{\link[wiggleplotr]{plotTranscripts}}) or 
(\code{\link[wiggleplotr]{plotTranscriptsFromEnsembldb}}) functions,  because indivudally extracting exon 
coordinates from txdb objects is quite inefficient.
}
\examples{
#Load OrgDb and TxDb objects with UCSC gene annotations
require("org.Hs.eg.db")
require("TxDb.Hsapiens.UCSC.hg38.knownGene")
orgdb = org.Hs.eg.db
txdb = TxDb.Hsapiens.UCSC.hg38.knownGene

plotTranscriptsFromUCSC(orgdb, txdb, "NCOA7", transcript_ids = c("ENST00000438495.6", "ENST00000368357.7"))
}
