% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePlots.R
\name{makeManhattanPlot}
\alias{makeManhattanPlot}
\title{Make a Manahattan plot of p-values}
\usage{
makeManhattanPlot(
  pvalues_df,
  region_coords,
  color_R2 = FALSE,
  data_track = TRUE
)
}
\arguments{
\item{pvalues_df}{Data frame of association p-values (required columns: track_id, p_nominal, pos)}

\item{region_coords}{Start and end coordinates of the region to plot.}

\item{color_R2}{Color the points according to R2 from the lead variant. Require R2 column in the pvalues_df data frame.}

\item{data_track}{If TRUE, then remove all information from x-axis. 
Makes it easy to append to read coverage or transcript strcture plots using cowplot::plot_grid().}
}
\value{
gglot2 object
}
\description{
The Manhattan plots is compatible with wiggpleplotr read coverage and transcript strucutre plots. 
Can be appended to those using the cowplot::plot_grid() function.
}
\examples{
data = dplyr::data_frame(track_id = "GWAS", pos = sample(c(1:1000), 200), p_nominal = runif(200, min = 0.0000001, 1))
makeManhattanPlot(data, c(1,1000), data_track = FALSE)
}
