% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wasserstein_metric}
\alias{wasserstein_metric}
\title{Calculate the p-Wasserstein distance}
\usage{
wasserstein_metric(x, y, p = 1, wa_ = NULL, wb_ = NULL)
}
\arguments{
\item{x}{sample (vector) representing the distribution of condition \eqn{A}}

\item{y}{sample (vector) representing the distribution of condition \eqn{B}}

\item{p}{order of the Wasserstein distance}

\item{wa_}{optional vector of weights for \code{x}}

\item{wb_}{optional vector of weights for \code{y}}
}
\value{
The \eqn{p}-Wasserstein distance between \eqn{x} and \eqn{y}
}
\description{
Calculates the \eqn{p}-Wasserstein distance (metric) between two vectors \eqn{x} and \eqn{y}
}
\details{
This implementation of the \eqn{p}-Wasserstein distance is a Rcpp reimplementation of
the \code{wasserstein1d} function from the R package \code{transport} by Schuhmacher et al.
}
\examples{
set.seed(24)
x<-rnorm(100)
y1<-rnorm(150)
y2<-rexp(150,3)
y3<-rpois(150,2)

#calculate 2-Wasserstein distance between x and y1
wasserstein_metric(x,y1,p=2)
#calculate squared 2-Wasserstein distance between x and y1
wasserstein_metric(x,y1,p=2)^2

#calculate 2-Wasserstein distance between x and y2
wasserstein_metric(x,y2,p=2)
#calculate squared 2-Wasserstein distance between x and y2
wasserstein_metric(x,y2,p=2)^2

#calculate 2-Wasserstein distance between x and y3
wasserstein_metric(x,y3,p=2)
#calculate squared 2-Wasserstein distance between x and y3
wasserstein_metric(x,y3,p=2)^2

}
\references{
Schefzik, R., Flesch, J., and Goncalves, A. (2020). waddR: Using the 2-Wasserstein distance to identify differences between distributions in two-sample testing, with application to single-cell RNA-sequencing data.
}
\seealso{
See the functions \code{squared_wass_approx} and \code{squared_wass_decomp} for
alternative implementations of the 2-Wasserstein distance.
}
