% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulcan.R
\name{vulcan.pathways}
\alias{vulcan.pathways}
\title{Function to calculate pathway enrichment over a ChIP-Seq profile}
\usage{
vulcan.pathways(
  vobj,
  pathways,
  contrast = NULL,
  method = c("GSEA", "REA"),
  np = 1000
)
}
\arguments{
\item{vobj}{a list, the output of the \code{'vulcan.annotate'} function}

\item{pathways}{a list of vectors, one vector of gene identifiers per
pathway}

\item{contrast}{a vector with the name of the two conditions to
compare. If method=='REA', contrast can be set to 'all', and Rank Enrichment
Analysis will be performed for every sample independently, compared to the
mean of the dataset.}

\item{method}{either 'REA' for Rank Enrichment Analysis or 'GSEA' for Gene
Set Enrichment Analysis}

\item{np}{numeric, only for GSEA, the number of permutations to build the
null distribution. Default is 1000}
}
\value{
if method=='GSEA', a named vector, with pathway names as names,
and the normalized enrichment score of either the GSEA as value.
If method=='REA', a matrix, with pathway names as rows and specific
contrasts as columns (the method 'REA' allows for multiple contrasts to
be calculated at the same time)
}
\description{
This function applies Gene Set Enrichment Analysis or Rank Enrichment
Analysis over a ChIP-Seq signature contained in a vulcan package object
}
\examples{
library(vulcandata)
vfile<-tempfile()
vulcandata::vulcansheet(vfile)
#vobj<-vulcan.import(vfile)
vobj<-vulcandata::vulcanexample()
unlink(vfile)
vobj<-vulcan.annotate(vobj,lborder=-10000,rborder=10000,method='sum')
vobj<-vulcan.normalize(vobj)
# Create a dummy pathway list (in entrez ids)
pathways<-list(
   pathwayA=rownames(vobj$normalized)[1:20],
   pathwayB=rownames(vobj$normalized)[21:50]
)
# Which contrast groups can be queried
names(vobj$samples)
results_gsea<-vulcan.pathways(vobj,pathways,contrast=c('t90','t0'),
method='GSEA')
results_rea<-vulcan.pathways(vobj,pathways,contrast=c('all'),method='REA')
}
