% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{ppareto}
\alias{ppareto}
\title{Cumulative distribution function of the Pareto distributions
'
Gives NA on values < threshold}
\usage{
ppareto(x, threshold = 1, exponent, lower.tail = TRUE)
}
\arguments{
\item{x}{Data vector, lower threshold, scaling exponent, usual flags}

\item{threshold}{numeric value to define the start of the tail}

\item{exponent}{the exponent obtained from the pareto.fit function}

\item{lower.tail}{logical. If the lower tail of the distribution should be
considered. Default is TRUE}
}
\value{
Vector of (log) probabilities
}
\description{
Cumulative distribution function of the Pareto distributions
'
Gives NA on values < threshold
}
\examples{
# Estimate the tail of a pospulation normally distributed
set.seed(1)
x<-rnorm(1000)
q95<-as.numeric(quantile(abs(x),0.95))
fit<-pareto.fit(abs(x),threshold=q95)
# We can infer the pvalue of a value very much right to the tail of the
# distribution
value<-5
pvalue<-ppareto(value, threshold=q95, exponent=fit$exponent,
lower.tail=FALSE)/20
plot(density(abs(x)),xlim=c(0,value+0.3),main='Pareto fit')
arrows(value,0.2,value,0)
text(value,0.2,labels=paste0('p=',signif(pvalue,2)))
}
