% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{pareto.fit}
\alias{pareto.fit}
\title{Estimate parameters of Pareto distribution}
\usage{
pareto.fit(data, threshold)
}
\arguments{
\item{data}{data vector, lower threshold (or 'find', indicating it should be
found from the data), method (likelihood or regression, defaulting to former)}

\item{threshold}{numeric value to define the start of the tail}
}
\value{
List indicating type of distribution ('pareto'), parameters,
information about fit (depending on method), OR a warning and NA if method
is not recognized
}
\description{
A wrapper for functions implementing actual methods
}
\examples{
# Estimate the tail of a pospulation normally distributed
set.seed(1)
x<-rnorm(1000)
q95<-as.numeric(quantile(abs(x),0.95))
fit<-pareto.fit(abs(x),threshold=q95)
# We can infer the pvalue of a value very much right to the tail of the
# distribution
value<-5
pvalue<-ppareto(value, threshold=q95, exponent=fit$exponent,
lower.tail=FALSE)/20
plot(density(abs(x)),xlim=c(0,value+0.3),main='Pareto fit')
arrows(value,0.2,value,0)
text(value,0.2,labels=paste0('p=',signif(pvalue,2)))
}
