% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{null_gsea}
\alias{null_gsea}
\title{Calculate Null Distribution for GSEA}
\usage{
null_gsea(set, reflist, w = 1, np = 1000)
}
\arguments{
\item{set}{A vector containing gene names.}

\item{reflist}{A named vector containing the weights of the entire signature}

\item{w}{exponent used to raise the supplied scores. Default is 1 (original
scores unchanged)}

\item{np}{Number of permutations (Default: 1000)}
}
\value{
A vector of null scores appropriate for the set/reflist combination
provided
}
\description{
This function generates a GSEA null distribution from
}
\examples{
reflist<-setNames(-sort(rnorm(26)),LETTERS)
set<-c('A','B','D','F')
nulldist<-null_gsea(set,reflist)
nulldist[1:10]
}
