% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{kmgformat}
\alias{kmgformat}
\title{kmgformat - Nice Formatting of Numbers}
\usage{
kmgformat(input, roundParam = 1)
}
\arguments{
\item{input}{A vector of values}

\item{roundParam}{How many decimal digits you want}
}
\value{
A character vector of formatted numebr names
}
\description{
This function will convert thousand numbers to K, millions to M, billions
to G, trillions to T, quadrillions to P
}
\examples{
# Thousands
set.seed(1)
a<-runif(1000,0,1e4)
plot(a,yaxt='n')
kmg<-kmgformat(pretty(a))
axis(2,at=pretty(a),labels=kmg)

# Millions to Billions
set.seed(1)
a<-runif(1000,0,1e9)
plot(a,yaxt='n',pch=20,col=val2col(a))
kmg<-kmgformat(pretty(a))
axis(2,at=pretty(a),labels=kmg)
}
