% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{densityauc}
\alias{densityauc}
\title{densityauc - Calculate the AUC of a density object}
\usage{
densityauc(dens, window)
}
\arguments{
\item{dens}{a density object}

\item{window}{a vector with two values, specifying the left and right borders
for the AUC to be calculated}
}
\value{
a numeric value for the density AUC
}
\description{
This function will calculate the AUC of a density object generated by the
\code{'density'} function.
}
\examples{
set.seed(1)
a<-rnorm(1000)
d<-density(a)
window<-c(2,3)
da<-densityauc(d,window)

plot(d,main='')
abline(v=window,lty=2)
title(paste0('AUC between lines=',da))



}
