% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmrseqOptimControl.R
\name{vmrseqOptimControl}
\alias{vmrseqOptimControl}
\title{Auxiliary function as user interface for vmrseq optimization.}
\usage{
vmrseqOptimControl(
  inits = c(0.2, 0.5, 0.8),
  epsilon = 0.001,
  backtrack = TRUE,
  eta = ifelse(backtrack, 0.05, 0.005),
  maxIter = 100
)
}
\arguments{
\item{inits}{vector of numeric values between 0 and 1 representing initial
values of pi_1 shall be taken in optimization algorithm.}

\item{epsilon}{numeric value representing the convergence upper bound for
the algorithm.}

\item{backtrack}{logical value indicating whether to use backtracking line
search to automatically adjust learning rate. Default is TRUE.}

\item{eta}{a numeric value representing the learning rate in optimization.
Default is \code{ifelse(backtrack, 0.05, 0.005)}.}

\item{maxIter}{positive integer value representing the maximum number of
iterations in optimization algorithm.}
}
\value{
the list of arguments for optimization control
}
\description{
Typically only used when calling vmrseq function with the
option \code{control}.
}
\examples{
vmrseqOptimControl()


}
