% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_error_metrics.R
\name{.add_error_metrics}
\alias{.add_error_metrics}
\title{Add error metrics related to array-coordinate mapping}
\usage{
.add_error_metrics(coords, coords_new, inter_spot_dist_px)
}
\arguments{
\item{coords}{A \code{tibble()} containing \code{array_row}, \code{array_col}, \code{key},
\code{pxl_col_in_fullres}, \code{pxl_row_in_fullres}, \code{pxl_col_in_fullres_rounded},
\code{pxl_row_in_fullres_rounded}, and \code{capture_area} columns, representing data
before mapping to new array coordinates for one \code{group}.}

\item{coords_new}{A \code{tibble()} containing \code{array_row}, \code{array_col}, \code{key},
\code{pxl_col_in_fullres}, \code{pxl_row_in_fullres}, \code{pxl_col_in_fullres_rounded},
and \code{pxl_row_in_fullres_rounded} columns, representing data after mapping
to new array coordinates for one \code{group}.}

\item{inter_spot_dist_px}{A \code{numeric(1)} giving the number of pixels between
spots for the \code{group}.}
}
\value{
A \code{tibble()} copy of \code{coords_new} with additional \code{shared_neighbors}
and \code{euclidean_error} columns.
}
\description{
Given \code{tibble()}s before and after mapping to new array coordinates,
calculate metrics related to the suitability of the mapping.
}
\details{
Add column \code{shared_neighbors}, the fraction of neighbors a spot started
with that are retained after mapping; add column \code{euclidean_error}, the
number of multiples of the inter-spot distance a spot must move to be
placed in the new array coordinates.
}
\author{
Nicholas J. Eagles
}
\keyword{internal}
