% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_overlap_info.R
\name{add_overlap_info}
\alias{add_overlap_info}
\title{Add info about how spots overlap among capture areas}
\usage{
add_overlap_info(spe, metric_name)
}
\arguments{
\item{spe}{A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
with \code{colData(spe)} columns
\code{array_row}, \code{array_col}, \code{key}, and
\code{capture_area}.}

\item{metric_name}{\code{character(1)} in \code{colnames(colData(spe))}, where
spots belonging to the capture area with highest average value for the metric
take precedence over other spots.}
}
\value{
A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment}
object with additional \code{colData} columns \code{spe$exclude_overlapping}
and \code{spe$overlap_key}.
}
\description{
Given a \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
and column name in its \code{colData},
return a modified copy of the \code{SpatialExperiment} with additional \code{colData}
columns: \code{spe$exclude_overlapping} and \code{spe$overlap_key}.
}
\details{
\code{spe$exclude_overlapping} is \code{TRUE} for spots with a higher-quality
overlapping capture area and \code{FALSE} otherwise.
\link[spatialLIBD:vis_clus]{vis_clus} onlydisplays \code{FALSE} spots to
prevent overplotting in regions of overlap. \code{spe$overlap_key} gives
comma-separated strings containing the keys of any overlapping spots, and is
the empty string otherwise.
}
\examples{
if (!exists("spe")) {
    spe <- spatialLIBD::fetch_data(type = "visiumStitched_brain_spe")
}

#    Find the mean of the 'sum_umi' metric by capture area to understand
#    which capture areas will be excluded in regions of overlap
SummarizedExperiment::colData(spe) |>
    dplyr::as_tibble() |>
    dplyr::group_by(capture_area) |>
    dplyr::summarize(mean_sum_umi = mean(sum_umi))

spe <- add_overlap_info(spe, "sum_umi")

#    See how many spots were excluded by capture area
table(spe$exclude_overlapping, spe$capture_area)

#    Examine how data about overlapping spots is stored (for the first
#    few spots with overlap)
head(spe$overlap_key[spe$overlap_key != ""])
}
\author{
Nicholas J. Eagles
}
